/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.config;

import com.lmax.disruptor.ExceptionHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.function.EvalScript;
import org.wso2.siddhi.core.util.ElementIdGenerator;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.persistence.PersistenceService;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.core.util.statistics.StatisticsManager;
import org.wso2.siddhi.core.util.timestamp.TimestampGenerator;

public class ExecutionPlanContext {
    private SiddhiContext siddhiContext;
    private String name;
    private boolean playback;
    private boolean enforceOrder;
    private boolean async;
    private boolean statsEnabled = false;
    private boolean cleanAggregators = true;
    private StatisticsManager statisticsManager = null;
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private List<EternalReferencedHolder> eternalReferencedHolders = new CopyOnWriteArrayList<EternalReferencedHolder>();
    private SnapshotService snapshotService;
    private ThreadBarrier threadBarrier = null;
    private TimestampGenerator timestampGenerator = null;
    private PersistenceService persistenceService;
    private ElementIdGenerator elementIdGenerator;
    private Map<String, EvalScript> scriptFunctionMap = new HashMap<String, EvalScript>();
    private ExceptionHandler<Object> disruptorExceptionHandler;
    private int bufferSize;
    private int cleanAggregatorInterval = 60;

    public SiddhiContext getSiddhiContext() {
        return this.siddhiContext;
    }

    public void setSiddhiContext(SiddhiContext siddhiContext) {
        this.siddhiContext = siddhiContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isPlayback() {
        return this.playback;
    }

    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    public boolean isEnforceOrder() {
        return this.enforceOrder;
    }

    public void setEnforceOrder(boolean enforceOrder) {
        this.enforceOrder = enforceOrder;
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void addEternalReferencedHolder(EternalReferencedHolder eternalReferencedHolder) {
        this.eternalReferencedHolders.add(eternalReferencedHolder);
    }

    public List<EternalReferencedHolder> getEternalReferencedHolders() {
        return this.eternalReferencedHolders;
    }

    public ThreadBarrier getThreadBarrier() {
        return this.threadBarrier;
    }

    public void setThreadBarrier(ThreadBarrier threadBarrier) {
        this.threadBarrier = threadBarrier;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public TimestampGenerator getTimestampGenerator() {
        return this.timestampGenerator;
    }

    public void setTimestampGenerator(TimestampGenerator timestampGenerator) {
        this.timestampGenerator = timestampGenerator;
    }

    public SnapshotService getSnapshotService() {
        return this.snapshotService;
    }

    public void setSnapshotService(SnapshotService snapshotService) {
        this.snapshotService = snapshotService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setElementIdGenerator(ElementIdGenerator elementIdGenerator) {
        this.elementIdGenerator = elementIdGenerator;
    }

    public ElementIdGenerator getElementIdGenerator() {
        return this.elementIdGenerator;
    }

    public EvalScript getEvalScript(String name) {
        return this.scriptFunctionMap.get(name);
    }

    public boolean isFunctionExist(String name) {
        return this.scriptFunctionMap.get(name) != null;
    }

    public Map<String, EvalScript> getScriptFunctionMap() {
        return this.scriptFunctionMap;
    }

    public void setDisruptorExceptionHandler(ExceptionHandler<Object> disruptorExceptionHandler) {
        this.disruptorExceptionHandler = disruptorExceptionHandler;
    }

    public ExceptionHandler<Object> getDisruptorExceptionHandler() {
        if (this.disruptorExceptionHandler != null) {
            return this.disruptorExceptionHandler;
        }
        return this.siddhiContext.getDefaultDisrupterExceptionHandler();
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setCleanAggregators(boolean value) {
        this.cleanAggregators = value;
    }

    public boolean getCleanAggregators() {
        return this.cleanAggregators;
    }

    public int getCleanAggregatorInterval() {
        return this.cleanAggregatorInterval;
    }

    public void setCleanAggregatorInterval(int cleanAggregatorInterval) {
        this.cleanAggregatorInterval = cleanAggregatorInterval;
    }
}

