/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.NoPersistenceStoreException;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;

public class PersistenceService {
    private static final Log LOGGER = LogFactory.getLog(PersistenceService.class);
    private String executionPlanName;
    private PersistenceStore persistenceStore;
    private SnapshotService snapshotService;
    private ThreadBarrier threadBarrier;

    public PersistenceService(ExecutionPlanContext executionPlanContext) {
        this.snapshotService = executionPlanContext.getSnapshotService();
        this.persistenceStore = executionPlanContext.getSiddhiContext().getPersistenceStore();
        this.executionPlanName = executionPlanContext.getName();
        this.threadBarrier = executionPlanContext.getThreadBarrier();
        SnapshotService.restoreSnapshotableElements();
    }

    public String persist() {
        if (this.persistenceStore != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Persisting...");
            }
            byte[] snapshot = this.snapshotService.snapshot();
            String revision = System.currentTimeMillis() + "_" + this.executionPlanName;
            this.persistenceStore.save(this.executionPlanName, revision, snapshot);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Persisted.");
            }
            return revision;
        }
        throw new NoPersistenceStoreException("No persistence store assigned for execution plan " + this.executionPlanName);
    }

    public void restoreRevision(String revision) {
        if (this.persistenceStore != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Restoring revision: " + revision + " ..."));
            }
            byte[] snapshot = this.persistenceStore.load(this.executionPlanName, revision);
            this.snapshotService.restore(snapshot);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Restored revision: " + revision));
            }
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for execution plan " + this.executionPlanName);
        }
    }

    public void restoreLastRevision() {
        block5: {
            try {
                this.threadBarrier.lock();
                if (this.persistenceStore != null) {
                    String revision = this.persistenceStore.getLastRevision(this.executionPlanName);
                    if (revision != null) {
                        this.restoreRevision(revision);
                    }
                    break block5;
                }
                throw new NoPersistenceStoreException("No persistence store assigned for execution plan " + this.executionPlanName);
            }
            finally {
                this.threadBarrier.unlock();
            }
        }
    }
}

