/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.Scheduler;

public class SystemTimeBasedScheduler
extends Scheduler {
    private static final Log log = LogFactory.getLog(SystemTimeBasedScheduler.class);
    private EventCaller eventCaller;
    private volatile boolean running = false;
    private ScheduledExecutorService scheduledExecutorService;

    public SystemTimeBasedScheduler(ScheduledExecutorService scheduledExecutorService, Schedulable singleThreadEntryValve, ExecutionPlanContext executionPlanContext) {
        super(singleThreadEntryValve, executionPlanContext);
        this.scheduledExecutorService = scheduledExecutorService;
        this.eventCaller = new EventCaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(long time) {
        if (!this.running && this.toNotifyQueue.size() == 1) {
            BlockingQueue blockingQueue = this.toNotifyQueue;
            synchronized (blockingQueue) {
                if (!this.running) {
                    this.running = true;
                    long timeDiff = time - this.executionPlanContext.getTimestampGenerator().currentTime();
                    if (timeDiff > 0L) {
                        this.scheduledExecutorService.schedule(this.eventCaller, timeDiff, TimeUnit.MILLISECONDS);
                    } else {
                        this.scheduledExecutorService.schedule(this.eventCaller, 0L, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }

    @Override
    public Scheduler clone(String key, EntryValveProcessor entryValveProcessor) {
        SystemTimeBasedScheduler scheduler = new SystemTimeBasedScheduler(this.scheduledExecutorService, entryValveProcessor, this.executionPlanContext);
        scheduler.elementId = this.elementId + "-" + key;
        return scheduler;
    }

    private class EventCaller
    implements Runnable {
        private EventCaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    SystemTimeBasedScheduler.this.sendTimerEvents();
                    Long toNotifyTime = (Long)SystemTimeBasedScheduler.this.toNotifyQueue.peek();
                    long currentTime = SystemTimeBasedScheduler.this.executionPlanContext.getTimestampGenerator().currentTime();
                    if (SystemTimeBasedScheduler.this.executionPlanContext.isPlayback()) break block7;
                    if (toNotifyTime != null) {
                        SystemTimeBasedScheduler.this.scheduledExecutorService.schedule(SystemTimeBasedScheduler.this.eventCaller, toNotifyTime - currentTime, TimeUnit.MILLISECONDS);
                        break block7;
                    }
                    BlockingQueue blockingQueue = SystemTimeBasedScheduler.this.toNotifyQueue;
                    synchronized (blockingQueue) {
                        SystemTimeBasedScheduler.this.running = false;
                        if (SystemTimeBasedScheduler.this.toNotifyQueue.peek() != null) {
                            SystemTimeBasedScheduler.this.running = true;
                            SystemTimeBasedScheduler.this.scheduledExecutorService.schedule(SystemTimeBasedScheduler.this.eventCaller, 0L, TimeUnit.MILLISECONDS);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)t);
                }
            }
        }
    }
}

