/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiddhiExtensionLoader {
    private static final String CLASS_PATH = "java.class.path";
    private static final String CLASS_EXT = "[^#]\\S+=\\S+";
    private static final String SIDDHI_EXT = ".*\\.siddhiext";
    private static final String JAR = ".*\\.jar";
    private static final Log log = LogFactory.getLog(SiddhiExtensionLoader.class);

    public static Map<String, Class> loadSiddhiExtensions() {
        String classPath = System.getProperty(CLASS_PATH);
        classPath = classPath == null ? "." : classPath + File.pathSeparator + ".";
        String[] classPathElements = classPath.split(File.pathSeparator);
        Pattern pattern = Pattern.compile(SIDDHI_EXT);
        ArrayList<String> extensionsList = new ArrayList<String>();
        for (String element : classPathElements) {
            Collection<String> stringCollection = SiddhiExtensionLoader.getResources(element, pattern);
            if (stringCollection == null || stringCollection.isEmpty()) continue;
            extensionsList.addAll(stringCollection);
        }
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        for (String extension : extensionsList) {
            if (!extension.matches(CLASS_EXT)) continue;
            String[] info = extension.split("=");
            try {
                classMap.put(info[0].trim(), Class.forName(info[1].trim()));
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)("Cannot load Siddhi extension " + extension));
            }
        }
        return classMap;
    }

    private static Collection<String> getResources(String fileName, Pattern pattern) {
        File file = new File(fileName);
        Collection<String> stringCollection = null;
        if (file.exists()) {
            stringCollection = SiddhiExtensionLoader.getContent(file, pattern);
        }
        return stringCollection;
    }

    private static Collection<String> getContent(File file, Pattern pattern) {
        ArrayList<String> resources = new ArrayList<String>();
        if (file.isDirectory()) {
            resources.addAll(SiddhiExtensionLoader.getContentFromDirectory(file, pattern));
        } else {
            String fileName = file.getName();
            Pattern jar = Pattern.compile(JAR);
            if (jar.matcher(fileName).matches()) {
                resources.addAll(SiddhiExtensionLoader.getContentFromJarFile(file, pattern));
            } else if (pattern.matcher(fileName).matches()) {
                try {
                    FileInputStream inputStream = new FileInputStream(file.getCanonicalPath());
                    resources.addAll(SiddhiExtensionLoader.readContent(fileName, inputStream));
                }
                catch (IOException ex) {
                    log.error((Object)("unable to get input stream of " + fileName), (Throwable)ex);
                }
            }
        }
        return resources;
    }

    private static Collection<String> getContentFromDirectory(File directory, Pattern pattern) {
        ArrayList<String> resources = new ArrayList<String>();
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                resources.addAll(SiddhiExtensionLoader.getContent(file, pattern));
            }
        }
        return resources;
    }

    private static Collection<String> getContentFromJarFile(File file, Pattern pattern) {
        ArrayList<String> resources = new ArrayList<String>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error viewing zip file for jar:" + file), (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error viewing zip file for jar:" + file), (Throwable)e);
        }
        if (zf != null) {
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String fileName = ze.getName();
                if (!pattern.matcher(fileName).matches()) continue;
                try {
                    InputStream inputStream = zf.getInputStream(ze);
                    resources.addAll(SiddhiExtensionLoader.readContent(fileName, inputStream));
                }
                catch (IOException ex) {
                    log.error((Object)("unable to get input stream of " + fileName + "in jar:" + file), (Throwable)ex);
                }
            }
            try {
                zf.close();
            }
            catch (IOException e1) {
                log.error((Object)("Error closing zip file created for jar:" + file), (Throwable)e1);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> readContent(String fileName, InputStream inputStream) {
        ArrayList<String> resources = new ArrayList<String>();
        String namespace = fileName.split("\\.")[0];
        try {
            try {
                String extensionDetails;
                BufferedReader br = new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
                while ((extensionDetails = br.readLine()) != null) {
                    resources.add(namespace + ":" + extensionDetails);
                }
                br.close();
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ex) {
            log.error((Object)("unable to read file " + fileName + ex));
        }
        return resources;
    }
}

