/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.timestamp.EventTimeBasedMillisTimestampGenerator;

public class EventTimeBasedScheduler
extends Scheduler {
    public EventTimeBasedScheduler(Schedulable singleThreadEntryValve, ExecutionPlanContext executionPlanContext) {
        super(singleThreadEntryValve, executionPlanContext);
        if (executionPlanContext.isPlayback()) {
            ((EventTimeBasedMillisTimestampGenerator)executionPlanContext.getTimestampGenerator()).addTimeChangeListener(new EventTimeBasedMillisTimestampGenerator.TimeChangeListener(){

                @Override
                public void onTimeChange(long currentTimestamp) {
                    Long lastTime = (Long)EventTimeBasedScheduler.this.toNotifyQueue.peek();
                    if (lastTime != null && lastTime <= currentTimestamp) {
                        EventTimeBasedScheduler.this.sendTimerEvents();
                    }
                }
            });
        }
    }

    @Override
    public void schedule(long time) {
    }

    @Override
    public Scheduler clone(String key, EntryValveProcessor entryValveProcessor) {
        EventTimeBasedScheduler scheduler = new EventTimeBasedScheduler(entryValveProcessor, this.executionPlanContext);
        scheduler.elementId = this.elementId + "-" + key;
        return scheduler;
    }
}

