/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.trigger;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.trigger.EventTrigger;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;

public class CronEventTrigger
implements EventTrigger,
Job {
    protected static final Log log = LogFactory.getLog(CronEventTrigger.class);
    private TriggerDefinition triggerDefinition;
    private ExecutionPlanContext executionPlanContext;
    private StreamJunction streamJunction;
    private Scheduler scheduler;
    private String jobName;
    private String jobGroup = "TriggerGroup";

    @Override
    public void init(TriggerDefinition triggerDefinition, ExecutionPlanContext executionPlanContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.executionPlanContext = executionPlanContext;
        this.streamJunction = streamJunction;
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        this.scheduleCronJob(this.triggerDefinition.getAt(), this.triggerDefinition.getId());
    }

    @Override
    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.deleteJob(new JobKey(this.jobName, this.jobGroup));
            }
        }
        catch (SchedulerException e) {
            log.error((Object)("Error while removing the cron trigger job, " + e.getMessage()), (Throwable)e);
        }
    }

    private void scheduleCronJob(String cronString, String elementId) {
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            this.scheduler = schedulerFactory.getScheduler();
            this.jobName = "TriggerJob_" + elementId;
            JobKey jobKey = new JobKey(this.jobName, this.jobGroup);
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
            this.scheduler.start();
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("trigger", (Object)this);
            JobDetail job = JobBuilder.newJob(CronEventTrigger.class).withIdentity(this.jobName, this.jobGroup).usingJobData(dataMap).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("TriggerJob_" + elementId, this.jobGroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            log.error((Object)("Error while instantiating quartz scheduler for trigger '" + this.triggerDefinition.getId() + "'," + e.getMessage()), (Throwable)e);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        CronEventTrigger cronEventTrigger = (CronEventTrigger)dataMap.get((Object)"trigger");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running Trigger Job '" + cronEventTrigger.getId() + "'"));
        }
        cronEventTrigger.sendEvent();
    }

    private void sendEvent() {
        long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
        this.streamJunction.sendEvent(new Event(currentTime, new Object[]{currentTime}));
    }
}

