/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.input;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputProcessor;

public class InputHandler {
    private static final Log log = LogFactory.getLog(InputHandler.class);
    protected String streamId;
    protected int streamIndex;
    protected InputProcessor inputProcessor;
    protected InputProcessor pausedInputPublisher;

    public InputHandler(String streamId, int streamIndex, InputProcessor inputProcessor) {
        this.streamId = streamId;
        this.streamIndex = streamIndex;
        this.pausedInputPublisher = this.inputProcessor = inputProcessor;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void send(Object[] data) throws InterruptedException {
        if (this.inputProcessor != null) {
            this.inputProcessor.send(System.currentTimeMillis(), data, this.streamIndex);
        }
    }

    public void send(long timeStamp, Object[] data) throws InterruptedException {
        if (this.inputProcessor != null) {
            this.inputProcessor.send(timeStamp, data, this.streamIndex);
        }
    }

    public void send(Event event) throws InterruptedException {
        if (this.inputProcessor != null) {
            this.inputProcessor.send(event, this.streamIndex);
        }
    }

    public void send(Event[] events) throws InterruptedException {
        if (this.inputProcessor != null) {
            this.inputProcessor.send(events, this.streamIndex);
        }
    }

    void disconnect() {
        this.inputProcessor = null;
    }

    void resume() {
        this.inputProcessor = this.pausedInputPublisher;
    }
}

