/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class DistinctcountAttributeAggregator
extends AttributeAggregator {
    private Map<Object, Long> distinctValues = new HashMap<Object, Long>();

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Distinct count aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }

    @Override
    public Object processAdd(Object data) {
        Long preVal = this.distinctValues.get(data);
        if (preVal != null) {
            preVal = preVal + 1L;
            this.distinctValues.put(data, preVal);
        } else {
            this.distinctValues.put(data, 1L);
        }
        return this.getDistinctCount();
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        Long preVal;
        Long l = preVal = this.distinctValues.get(data);
        Long l2 = preVal = Long.valueOf(preVal - 1L);
        if (preVal > 0L) {
            this.distinctValues.put(data, preVal);
        } else {
            this.distinctValues.remove(data);
        }
        return this.getDistinctCount();
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        this.distinctValues.clear();
        return this.getDistinctCount();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, Map<Object, Long>>("DistinctValues", this.distinctValues)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.distinctValues = (Map)stateEntry.getValue();
    }

    private long getDistinctCount() {
        return this.distinctValues.size();
    }
}

