/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

public class ExternalTimeBatchWindowProcessor
extends WindowProcessor
implements SchedulingProcessor,
FindableProcessor {
    private ComplexEventChunk<StreamEvent> currentEventChunk = new ComplexEventChunk(false);
    private ComplexEventChunk<StreamEvent> expiredEventChunk = null;
    private StreamEvent resetEvent = null;
    private VariableExpressionExecutor timestampExpressionExecutor;
    private ExpressionExecutor startTimeAsVariable;
    private long timeToKeep;
    private long endTime = -1L;
    private long startTime = 0L;
    private boolean isStartTimeEnabled = false;
    private long schedulerTimeout = 0L;
    private Scheduler scheduler;
    private long lastScheduledTime;
    private long lastCurrentEventTime;
    private boolean flushed = false;
    private boolean storeExpiredEvents = false;
    private boolean replaceTimestampWithBatchEndTime = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (this.outputExpectsExpiredEvents) {
            this.expiredEventChunk = new ComplexEventChunk(false);
            this.storeExpiredEvents = true;
        }
        if (attributeExpressionExecutors.length < 2 || attributeExpressionExecutors.length > 5) throw new ExecutionPlanValidationException("ExternalTimeBatch window should only have two to five parameters (<long> timestamp, <int|long|time> windowTime, <long> startTime, <int|long|time> timeout, <bool> replaceTimestampWithBatchEndTime), but found " + attributeExpressionExecutors.length + " input attributes");
        if (!(attributeExpressionExecutors[0] instanceof VariableExpressionExecutor)) {
            throw new ExecutionPlanValidationException("ExternalTime window's 1st parameter timestamp should be a variable, but found " + attributeExpressionExecutors[0].getClass());
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("ExternalTime window's 1st parameter timestamp should be type long, but found " + attributeExpressionExecutors[0].getReturnType());
        }
        this.timestampExpressionExecutor = (VariableExpressionExecutor)attributeExpressionExecutors[0];
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("ExternalTime window's 2nd parameter should be a constant, but found " + attributeExpressionExecutors[1].getClass());
        }
        if (attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT) {
            this.timeToKeep = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()).intValue();
        } else {
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 2nd parameter windowTime should be either int or long, but found " + attributeExpressionExecutors[1].getReturnType());
            this.timeToKeep = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
        }
        if (attributeExpressionExecutors.length >= 3) {
            this.isStartTimeEnabled = true;
            if (attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor) {
                if (attributeExpressionExecutors[2].getReturnType() == Attribute.Type.INT) {
                    this.startTime = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue()));
                } else {
                    if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 3rd parameter startTime should either be a constant (of type int or long) or an attribute (of type long), but found " + attributeExpressionExecutors[2].getReturnType());
                    this.startTime = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue()));
                }
            } else {
                if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("ExternalTimeBatch window's 3rd parameter startTime should either be a constant (of type int or long) or an attribute (of type long), but found " + attributeExpressionExecutors[2].getReturnType());
                }
                this.startTimeAsVariable = attributeExpressionExecutors[2];
            }
        }
        if (attributeExpressionExecutors.length >= 4) {
            if (!(attributeExpressionExecutors[3] instanceof ConstantExpressionExecutor)) {
                throw new ExecutionPlanValidationException("ExternalTime window's 4th parameter should be a constant, but found " + attributeExpressionExecutors[3].getClass());
            }
            if (attributeExpressionExecutors[3].getReturnType() == Attribute.Type.INT) {
                this.schedulerTimeout = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue()));
            } else {
                if (attributeExpressionExecutors[3].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 4th parameter timeout should be either int or long, but found " + attributeExpressionExecutors[3].getReturnType());
                this.schedulerTimeout = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue()));
            }
        }
        if (attributeExpressionExecutors.length == 5) {
            if (!(attributeExpressionExecutors[4] instanceof ConstantExpressionExecutor)) {
                throw new ExecutionPlanValidationException("ExternalTime window's 5th parameter should be a constant, but found " + attributeExpressionExecutors[4].getClass());
            }
            if (attributeExpressionExecutors[4].getReturnType() != Attribute.Type.BOOL) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 5th parameter replaceTimestampWithBatchEndTime should be bool, but found " + attributeExpressionExecutors[4].getReturnType());
            this.replaceTimestampWithBatchEndTime = Boolean.parseBoolean(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[4]).getValue()));
        }
        if (this.schedulerTimeout <= 0L || this.expiredEventChunk != null) return;
        this.expiredEventChunk = new ComplexEventChunk(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        if (streamEventChunk.getFirst() == null) {
            return;
        }
        ArrayList<ComplexEventChunk<StreamEvent>> complexEventChunks = new ArrayList<ComplexEventChunk<StreamEvent>>();
        ExternalTimeBatchWindowProcessor externalTimeBatchWindowProcessor = this;
        synchronized (externalTimeBatchWindowProcessor) {
            void var6_7;
            this.initTiming(streamEventChunk.getFirst());
            StreamEvent streamEvent = streamEventChunk.getFirst();
            while (var6_7 != null) {
                void currStreamEvent = var6_7;
                StreamEvent streamEvent2 = var6_7.getNext();
                if (currStreamEvent.getType() == ComplexEvent.Type.TIMER) {
                    if (this.lastScheduledTime > currStreamEvent.getTimestamp()) continue;
                    if (!this.flushed) {
                        this.flushToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, true);
                        this.flushed = true;
                    } else if (this.currentEventChunk.getFirst() != null) {
                        this.appendToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, true);
                    }
                    this.lastScheduledTime = this.executionPlanContext.getTimestampGenerator().currentTime() + this.schedulerTimeout;
                    this.scheduler.notifyAt(this.lastScheduledTime);
                    continue;
                }
                if (currStreamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                long currentEventTime = (Long)this.timestampExpressionExecutor.execute((ComplexEvent)currStreamEvent);
                if (this.lastCurrentEventTime < currentEventTime) {
                    this.lastCurrentEventTime = currentEventTime;
                }
                if (currentEventTime < this.endTime) {
                    this.cloneAppend(streamEventCloner, (StreamEvent)currStreamEvent);
                    continue;
                }
                if (this.flushed) {
                    this.appendToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, false);
                    this.flushed = false;
                } else {
                    this.flushToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, false);
                }
                this.endTime = this.findEndTime(this.lastCurrentEventTime, this.startTime, this.timeToKeep);
                this.cloneAppend(streamEventCloner, (StreamEvent)currStreamEvent);
                if (this.schedulerTimeout <= 0L) continue;
                this.lastScheduledTime = this.executionPlanContext.getTimestampGenerator().currentTime() + this.schedulerTimeout;
                this.scheduler.notifyAt(this.lastScheduledTime);
            }
        }
        for (ComplexEventChunk complexEventChunk : complexEventChunks) {
            nextProcessor.process(complexEventChunk);
        }
    }

    private void initTiming(StreamEvent firstStreamEvent) {
        if (this.endTime < 0L) {
            if (this.isStartTimeEnabled) {
                if (this.startTimeAsVariable == null) {
                    this.endTime = this.findEndTime((Long)this.timestampExpressionExecutor.execute(firstStreamEvent), this.startTime, this.timeToKeep);
                } else {
                    this.startTime = (Long)this.startTimeAsVariable.execute(firstStreamEvent);
                    this.endTime = this.startTime + this.timeToKeep;
                }
            } else {
                this.startTime = (Long)this.timestampExpressionExecutor.execute(firstStreamEvent);
                this.endTime = this.startTime + this.timeToKeep;
            }
            if (this.schedulerTimeout > 0L) {
                this.lastScheduledTime = this.executionPlanContext.getTimestampGenerator().currentTime() + this.schedulerTimeout;
                this.scheduler.notifyAt(this.lastScheduledTime);
            }
        }
    }

    private void flushToOutputChunk(StreamEventCloner streamEventCloner, List<ComplexEventChunk<StreamEvent>> complexEventChunks, long currentTime, boolean preserveCurrentEvents) {
        ComplexEventChunk<StreamEvent> newEventChunk = new ComplexEventChunk<StreamEvent>(true);
        if (this.outputExpectsExpiredEvents && this.expiredEventChunk.getFirst() != null) {
            this.expiredEventChunk.reset();
            while (this.expiredEventChunk.hasNext()) {
                StreamEvent expiredEvent = (StreamEvent)this.expiredEventChunk.next();
                expiredEvent.setTimestamp(currentTime);
            }
            newEventChunk.add(this.expiredEventChunk.getFirst());
        }
        if (this.expiredEventChunk != null) {
            this.expiredEventChunk.clear();
        }
        if (this.currentEventChunk.getFirst() != null) {
            this.resetEvent.setTimestamp(currentTime);
            newEventChunk.add(this.resetEvent);
            this.resetEvent = null;
            if (preserveCurrentEvents || this.storeExpiredEvents) {
                this.currentEventChunk.reset();
                while (this.currentEventChunk.hasNext()) {
                    StreamEvent currentEvent = (StreamEvent)this.currentEventChunk.next();
                    StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEvent);
                    toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                    this.expiredEventChunk.add(toExpireEvent);
                }
            }
            newEventChunk.add(this.currentEventChunk.getFirst());
        }
        this.currentEventChunk.clear();
        if (newEventChunk.getFirst() != null) {
            complexEventChunks.add(newEventChunk);
        }
    }

    private void appendToOutputChunk(StreamEventCloner streamEventCloner, List<ComplexEventChunk<StreamEvent>> complexEventChunks, long currentTime, boolean preserveCurrentEvents) {
        ComplexEventChunk<StreamEvent> newEventChunk = new ComplexEventChunk<StreamEvent>(true);
        ComplexEventChunk<StreamEvent> sentEventChunk = new ComplexEventChunk<StreamEvent>(true);
        if (this.currentEventChunk.getFirst() != null) {
            if (this.expiredEventChunk.getFirst() != null) {
                this.expiredEventChunk.reset();
                while (this.expiredEventChunk.hasNext()) {
                    StreamEvent expiredEvent = (StreamEvent)this.expiredEventChunk.next();
                    if (this.outputExpectsExpiredEvents) {
                        StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(expiredEvent);
                        toExpireEvent.setTimestamp(currentTime);
                        newEventChunk.add(toExpireEvent);
                    }
                    StreamEvent toSendEvent = streamEventCloner.copyStreamEvent(expiredEvent);
                    toSendEvent.setType(ComplexEvent.Type.CURRENT);
                    sentEventChunk.add(toSendEvent);
                }
            }
            StreamEvent toResetEvent = streamEventCloner.copyStreamEvent(this.resetEvent);
            toResetEvent.setTimestamp(currentTime);
            newEventChunk.add(toResetEvent);
            newEventChunk.add((StreamEvent)sentEventChunk.getFirst());
            if (preserveCurrentEvents || this.storeExpiredEvents) {
                this.currentEventChunk.reset();
                while (this.currentEventChunk.hasNext()) {
                    StreamEvent currentEvent = (StreamEvent)this.currentEventChunk.next();
                    StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEvent);
                    toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                    this.expiredEventChunk.add(toExpireEvent);
                }
            }
            newEventChunk.add(this.currentEventChunk.getFirst());
        }
        this.currentEventChunk.clear();
        if (newEventChunk.getFirst() != null) {
            complexEventChunks.add(newEventChunk);
        }
    }

    private long findEndTime(long currentTime, long startTime, long timeToKeep) {
        long elapsedTimeSinceLastEmit = (currentTime - startTime) % timeToKeep;
        return currentTime + (timeToKeep - elapsedTimeSinceLastEmit);
    }

    private void cloneAppend(StreamEventCloner streamEventCloner, StreamEvent currStreamEvent) {
        StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(currStreamEvent);
        if (this.replaceTimestampWithBatchEndTime) {
            clonedStreamEvent.setAttribute(this.endTime, this.timestampExpressionExecutor.getPosition());
        }
        this.currentEventChunk.add(clonedStreamEvent);
        if (this.resetEvent == null) {
            this.resetEvent = streamEventCloner.copyStreamEvent(currStreamEvent);
            this.resetEvent.setType(ComplexEvent.Type.RESET);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, StreamEvent>("CurrentEventChunk", this.currentEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, Object>("ExpiredEventChunk", (this.expiredEventChunk != null ? this.expiredEventChunk.getFirst() : null)), new AbstractMap.SimpleEntry<String, StreamEvent>("ResetEvent", this.resetEvent), new AbstractMap.SimpleEntry<String, Long>("EndTime", this.endTime), new AbstractMap.SimpleEntry<String, Long>("StartTime", this.startTime), new AbstractMap.SimpleEntry<String, Long>("LastScheduledTime", this.lastScheduledTime), new AbstractMap.SimpleEntry<String, Long>("LastCurrentEventTime", this.lastCurrentEventTime), new AbstractMap.SimpleEntry<String, Boolean>("Flushed", this.flushed)};
    }

    @Override
    public void restoreState(Object[] state) {
        this.currentEventChunk.clear();
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.currentEventChunk.add((StreamEvent)stateEntry.getValue());
        if (((Map.Entry)state[1]).getValue() != null) {
            this.expiredEventChunk.clear();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.expiredEventChunk.add((StreamEvent)stateEntry2.getValue());
        } else {
            if (this.outputExpectsExpiredEvents) {
                this.expiredEventChunk = new ComplexEventChunk(false);
            }
            if (this.schedulerTimeout > 0L) {
                this.expiredEventChunk = new ComplexEventChunk(false);
            }
        }
        Map.Entry stateEntry3 = (Map.Entry)state[2];
        this.resetEvent = (StreamEvent)stateEntry3.getValue();
        Map.Entry stateEntry4 = (Map.Entry)state[3];
        this.endTime = (Long)stateEntry4.getValue();
        Map.Entry stateEntry5 = (Map.Entry)state[4];
        this.startTime = (Long)stateEntry5.getValue();
        Map.Entry stateEntry6 = (Map.Entry)state[5];
        this.lastScheduledTime = (Long)stateEntry6.getValue();
        Map.Entry stateEntry7 = (Map.Entry)state[6];
        this.lastCurrentEventTime = (Long)stateEntry7.getValue();
        Map.Entry stateEntry8 = (Map.Entry)state[7];
        this.flushed = (Boolean)stateEntry8.getValue();
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.expiredEventChunk, this.streamEventCloner);
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        if (this.expiredEventChunk == null) {
            this.expiredEventChunk = new ComplexEventChunk(false);
            this.storeExpiredEvents = true;
        }
        return OperatorParser.constructOperator(this.expiredEventChunk, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.queryName);
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

