/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public abstract class AbstractStreamProcessor
implements Processor,
EternalReferencedHolder,
Snapshotable {
    protected static final Log log = LogFactory.getLog(AbstractStreamProcessor.class);
    protected Processor nextProcessor;
    protected List<Attribute> additionalAttributes;
    protected StreamEventCloner streamEventCloner;
    protected AbstractDefinition inputDefinition;
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected ExecutionPlanContext executionPlanContext;
    protected int attributeExpressionLength;
    protected ComplexEventPopulater complexEventPopulater;
    protected String elementId = null;
    private boolean outputExpectsExpiredEvents;
    protected String queryName;

    public AbstractDefinition initProcessor(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext, boolean outputExpectsExpiredEvents, String queryName) {
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        try {
            this.inputDefinition = inputDefinition;
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.executionPlanContext = executionPlanContext;
            this.attributeExpressionLength = attributeExpressionExecutors.length;
            this.queryName = queryName;
            if (this.elementId == null) {
                this.elementId = "AbstractStreamProcessor-" + executionPlanContext.getElementIdGenerator().createNewId();
            }
            executionPlanContext.getSnapshotService().addSnapshotable(queryName, this);
            this.additionalAttributes = this.init(inputDefinition, attributeExpressionExecutors, executionPlanContext, outputExpectsExpiredEvents);
            executionPlanContext.addEternalReferencedHolder(this);
            StreamDefinition outputDefinition = StreamDefinition.id((String)inputDefinition.getId());
            for (Attribute attribute : inputDefinition.getAttributeList()) {
                outputDefinition.attribute(attribute.getName(), attribute.getType());
            }
            for (Attribute attribute : this.additionalAttributes) {
                outputDefinition.attribute(attribute.getName(), attribute.getType());
            }
            return outputDefinition;
        }
        catch (Throwable t) {
            throw new ExecutionPlanCreationException(t);
        }
    }

    protected abstract List<Attribute> init(AbstractDefinition var1, ExpressionExecutor[] var2, ExecutionPlanContext var3, boolean var4);

    @Override
    public void process(ComplexEventChunk streamEventChunk) {
        streamEventChunk.reset();
        try {
            this.processEventChunk(streamEventChunk, this.nextProcessor, this.streamEventCloner, this.complexEventPopulater);
        }
        catch (RuntimeException e) {
            log.error((Object)("Dropping event chunk " + streamEventChunk + ", error in processing " + this.getClass().getCanonicalName() + ", " + e.getMessage()), (Throwable)e);
        }
    }

    protected abstract void processEventChunk(ComplexEventChunk<StreamEvent> var1, Processor var2, StreamEventCloner var3, ComplexEventPopulater var4);

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public Processor cloneProcessor(String key) {
        try {
            AbstractStreamProcessor abstractStreamProcessor = (AbstractStreamProcessor)this.getClass().newInstance();
            abstractStreamProcessor.inputDefinition = this.inputDefinition;
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeExpressionLength];
            ExpressionExecutor[] attributeExpressionExecutors1 = this.attributeExpressionExecutors;
            for (int i = 0; i < this.attributeExpressionLength; ++i) {
                innerExpressionExecutors[i] = attributeExpressionExecutors1[i].cloneExecutor(key);
            }
            abstractStreamProcessor.attributeExpressionExecutors = innerExpressionExecutors;
            abstractStreamProcessor.attributeExpressionLength = this.attributeExpressionLength;
            abstractStreamProcessor.additionalAttributes = this.additionalAttributes;
            abstractStreamProcessor.complexEventPopulater = this.complexEventPopulater;
            abstractStreamProcessor.executionPlanContext = this.executionPlanContext;
            abstractStreamProcessor.elementId = this.elementId + "-" + key;
            abstractStreamProcessor.outputExpectsExpiredEvents = this.outputExpectsExpiredEvents;
            abstractStreamProcessor.queryName = this.queryName;
            abstractStreamProcessor.executionPlanContext.getSnapshotService().addSnapshotable(this.queryName, abstractStreamProcessor);
            abstractStreamProcessor.executionPlanContext.addEternalReferencedHolder(abstractStreamProcessor);
            abstractStreamProcessor.init(this.inputDefinition, this.attributeExpressionExecutors, this.executionPlanContext, this.outputExpectsExpiredEvents);
            abstractStreamProcessor.start();
            return abstractStreamProcessor;
        }
        catch (Exception e) {
            throw new ExecutionPlanRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    public void constructStreamEventPopulater(MetaStreamEvent metaStreamEvent, int streamEventChainIndex) {
        if (this.complexEventPopulater == null) {
            this.complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamEvent, streamEventChainIndex, this.additionalAttributes);
        }
    }

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventCloner = streamEventCloner;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

