/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.time;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;

public class FirstPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    private String id;
    private final Long value;
    private ComplexEvent firstEvent = null;
    private ScheduledExecutorService scheduledExecutorService;
    private Scheduler scheduler;
    private long scheduledTime;
    private String queryName;
    static final Log log = LogFactory.getLog(FirstPerTimeOutputRateLimiter.class);

    public FirstPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, String queryName) {
        this.queryName = queryName;
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstPerTimeOutputRateLimiter instance = new FirstPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.queryName);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList outputEventChunks = new ArrayList();
        complexEventChunk.reset();
        FirstPerTimeOutputRateLimiter firstPerTimeOutputRateLimiter = this;
        synchronized (firstPerTimeOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    if (object.getTimestamp() < this.scheduledTime) continue;
                    if (this.firstEvent != null) {
                        this.firstEvent = null;
                    }
                    this.scheduledTime += this.value.longValue();
                    this.scheduler.notifyAt(this.scheduledTime);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED || this.firstEvent != null) continue;
                complexEventChunk.remove();
                this.firstEvent = object;
                ComplexEventChunk<Object> firstPerEventChunk = new ComplexEventChunk<Object>(complexEventChunk.isBatch());
                firstPerEventChunk.add(object);
                outputEventChunks.add(firstPerEventChunk);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this.scheduledExecutorService, this, this.executionPlanContext);
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.queryName);
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, ComplexEvent>("FirstEvent", this.firstEvent)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.firstEvent = (ComplexEvent)stateEntry.getValue();
    }
}

