/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.event;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;

public class FirstGroupByPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private ComplexEventChunk<ComplexEvent> allComplexEventChunk;
    private volatile int counter = 0;
    List<String> groupByKeys = new ArrayList<String>();

    public FirstGroupByPerEventOutputRateLimiter(String id, Integer value) {
        this.id = id;
        this.value = value;
        this.allComplexEventChunk = new ComplexEventChunk(false);
    }

    @Override
    public OutputRateLimiter clone(String key) {
        FirstGroupByPerEventOutputRateLimiter instance = new FirstGroupByPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList outputEventChunks = new ArrayList();
        FirstGroupByPerEventOutputRateLimiter firstGroupByPerEventOutputRateLimiter = this;
        synchronized (firstGroupByPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED) continue;
                complexEventChunk.remove();
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)object;
                if (!this.groupByKeys.contains(groupedComplexEvent.getGroupKey())) {
                    this.groupByKeys.add(groupedComplexEvent.getGroupKey());
                    this.allComplexEventChunk.add(groupedComplexEvent.getComplexEvent());
                }
                if (++this.counter != this.value) continue;
                if (this.allComplexEventChunk.getFirst() != null) {
                    ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                    outputEventChunk.add(this.allComplexEventChunk.getFirst());
                    outputEventChunks.add(outputEventChunk);
                    this.allComplexEventChunk.clear();
                    this.counter = 0;
                    this.groupByKeys.clear();
                    continue;
                }
                this.counter = 0;
                this.groupByKeys.clear();
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, ComplexEventChunk<ComplexEvent>>("AllComplexEventChunk", this.allComplexEventChunk), new AbstractMap.SimpleEntry<String, List<String>>("GroupByKeys", this.groupByKeys), new AbstractMap.SimpleEntry<String, Integer>("Counter", this.counter)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.allComplexEventChunk = (ComplexEventChunk)stateEntry.getValue();
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.groupByKeys = (List)stateEntry2.getValue();
        Map.Entry stateEntry3 = (Map.Entry)state[2];
        this.counter = (Integer)stateEntry3.getValue();
    }
}

