/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.callback.QueryCallback;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.parser.OutputParser;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateAnnotationException;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class QueryRuntime {
    private final ExecutionPlanContext executionPlanContext;
    private StreamRuntime streamRuntime;
    private OutputRateLimiter outputRateLimiter;
    private String queryId;
    private Query query;
    private OutputCallback outputCallback;
    private boolean synchronised;
    private StreamDefinition outputStreamDefinition;
    private boolean toLocalStream;
    private QuerySelector selector;
    private MetaComplexEvent metaComplexEvent;

    public QueryRuntime(Query query, ExecutionPlanContext executionPlanContext, StreamRuntime streamRuntime, QuerySelector selector, OutputRateLimiter outputRateLimiter, OutputCallback outputCallback, MetaComplexEvent metaComplexEvent, boolean synchronised) {
        this.query = query;
        this.executionPlanContext = executionPlanContext;
        this.streamRuntime = streamRuntime;
        this.selector = selector;
        this.outputCallback = outputCallback;
        this.synchronised = synchronised;
        outputRateLimiter.setOutputCallback(outputCallback);
        this.setOutputRateLimiter(outputRateLimiter);
        this.setMetaComplexEvent(metaComplexEvent);
        this.setId();
        this.init();
    }

    private void setId() {
        try {
            Element element = AnnotationHelper.getAnnotationElement((String)"info", (String)"name", (List)this.query.getAnnotations());
            if (element != null) {
                this.queryId = element.getValue();
            }
        }
        catch (DuplicateAnnotationException e) {
            throw new DuplicateAnnotationException(e.getMessage() + " for the same Query " + this.query.toString());
        }
        if (this.queryId == null) {
            this.queryId = UUID.randomUUID().toString();
        }
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void addCallback(QueryCallback callback) {
        this.outputRateLimiter.addQueryCallback(callback);
    }

    public OutputRateLimiter getOutputRateManager() {
        return this.outputRateLimiter;
    }

    public StreamDefinition getOutputStreamDefinition() {
        return this.outputStreamDefinition;
    }

    public List<String> getInputStreamId() {
        return this.query.getInputStream().getAllStreamIds();
    }

    public boolean isToLocalStream() {
        return this.toLocalStream;
    }

    public void setToLocalStream(boolean toLocalStream) {
        this.toLocalStream = toLocalStream;
    }

    public boolean isFromLocalStream() {
        if (this.query.getInputStream() instanceof SingleInputStream) {
            return ((SingleInputStream)this.query.getInputStream()).isInnerStream();
        }
        if (this.query.getInputStream() instanceof JoinInputStream) {
            return ((SingleInputStream)((JoinInputStream)this.query.getInputStream()).getLeftInputStream()).isInnerStream() || ((SingleInputStream)((JoinInputStream)this.query.getInputStream()).getRightInputStream()).isInnerStream();
        }
        if (this.query.getInputStream() instanceof StateInputStream) {
            for (String streamId : this.query.getInputStream().getAllStreamIds()) {
                if (!streamId.startsWith("#")) continue;
                return true;
            }
        }
        return false;
    }

    public QueryRuntime clone(String key, ConcurrentMap<String, StreamJunction> localStreamJunctionMap) {
        LockWrapper lockWrapper = null;
        if (this.synchronised) {
            lockWrapper = new LockWrapper("");
            lockWrapper.setLock(new ReentrantLock());
        }
        StreamRuntime clonedStreamRuntime = this.streamRuntime.clone(key);
        QuerySelector clonedSelector = this.selector.clone(key);
        OutputRateLimiter clonedOutputRateLimiter = this.outputRateLimiter.clone(key);
        clonedOutputRateLimiter.init(this.executionPlanContext, lockWrapper, this.queryId);
        QueryRuntime queryRuntime = new QueryRuntime(this.query, this.executionPlanContext, clonedStreamRuntime, clonedSelector, clonedOutputRateLimiter, this.outputCallback, this.metaComplexEvent, this.synchronised);
        QueryParserHelper.initStreamRuntime(clonedStreamRuntime, this.metaComplexEvent, lockWrapper, this.queryId);
        queryRuntime.queryId = this.queryId + key;
        queryRuntime.setToLocalStream(this.toLocalStream);
        if (!this.toLocalStream) {
            queryRuntime.outputRateLimiter.setOutputCallback(this.outputCallback);
            queryRuntime.outputCallback = this.outputCallback;
        } else {
            OutputCallback clonedQueryOutputCallback = OutputParser.constructOutputCallback(this.query.getOutputStream(), key, localStreamJunctionMap, this.outputStreamDefinition, this.executionPlanContext, this.queryId);
            queryRuntime.outputRateLimiter.setOutputCallback(clonedQueryOutputCallback);
            queryRuntime.outputCallback = clonedQueryOutputCallback;
        }
        return queryRuntime;
    }

    private void setOutputRateLimiter(OutputRateLimiter outputRateLimiter) {
        this.outputRateLimiter = outputRateLimiter;
        this.selector.setNextProcessor(outputRateLimiter);
    }

    public StreamRuntime getStreamRuntime() {
        return this.streamRuntime;
    }

    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaComplexEvent;
    }

    private void setMetaComplexEvent(MetaComplexEvent metaComplexEvent) {
        this.outputStreamDefinition = metaComplexEvent.getOutputStreamDefinition();
        this.metaComplexEvent = metaComplexEvent;
    }

    public Query getQuery() {
        return this.query;
    }

    public OutputCallback getOutputCallback() {
        return this.outputCallback;
    }

    public void init() {
        this.streamRuntime.setCommonProcessor(this.selector);
    }

    public QuerySelector getSelector() {
        return this.selector;
    }
}

