/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.util.snapshot.SnapshotableElement;

public class SnapshotableElementsHolder {
    private static final Log LOGGER = LogFactory.getLog(SnapshotableElementsHolder.class);
    private static final Map<String, SnapshotableElement> SNAPSHOTABLE_ELEMENT_MAP = new HashMap<String, SnapshotableElement>();
    private static Map<String, Map<String, Object>> existingStates = new HashMap<String, Map<String, Object>>();

    public static void putExistingState(String elementName, Map<String, Object> existingData) {
        existingStates.put(elementName, existingData);
    }

    public static void registerSnapshotableElement(SnapshotableElement element) {
        Map<String, Object> existingState = existingStates.get(element.getElementId());
        if (existingState != null) {
            element.restoreState(existingState);
            existingState.remove(element.getElementId());
        }
        SNAPSHOTABLE_ELEMENT_MAP.put(element.getElementId(), element);
        LOGGER.info((Object)("Snapshotable Element " + element.getElementId() + " registered successfully."));
    }

    public static Map<String, Object> getState(String elementId) {
        Map<String, Object> state = SNAPSHOTABLE_ELEMENT_MAP.get(elementId) != null ? SNAPSHOTABLE_ELEMENT_MAP.get(elementId).currentState() : existingStates.get(elementId);
        return state;
    }

    public List<SnapshotableElement> getSnapshotableElements() {
        return new ArrayList<SnapshotableElement>(SNAPSHOTABLE_ELEMENT_MAP.values());
    }

    public SnapshotableElement getSnapshotableElement(String elementName) {
        return SNAPSHOTABLE_ELEMENT_MAP.get(elementName);
    }
}

