/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.filter.FilterProcessor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.SiddhiClassLoader;
import org.wso2.siddhi.core.util.extension.holder.StreamFunctionProcessorExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.StreamProcessorExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.WindowProcessorExtensionHolder;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.core.util.parser.SchedulerParser;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.execution.query.input.handler.Filter;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamFunction;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamHandler;
import org.wso2.siddhi.query.api.execution.query.input.handler.Window;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.extension.Extension;

public class SingleInputStreamParser {
    public static SingleStreamRuntime parseInputStream(SingleInputStream inputStream, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, EventTable> eventTableMap, MetaComplexEvent metaComplexEvent, ProcessStreamReceiver processStreamReceiver, boolean supportsBatchProcessing, boolean outputExpectsExpiredEvents, String queryName) {
        MetaStreamEvent metaStreamEvent;
        Processor processor = null;
        EntryValveProcessor entryValveProcessor = null;
        boolean first = true;
        if (metaComplexEvent instanceof MetaStateEvent) {
            metaStreamEvent = new MetaStreamEvent();
            ((MetaStateEvent)metaComplexEvent).addEvent(metaStreamEvent);
            SingleInputStreamParser.initMetaStreamEvent(inputStream, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, metaStreamEvent);
        } else {
            metaStreamEvent = (MetaStreamEvent)metaComplexEvent;
            SingleInputStreamParser.initMetaStreamEvent(inputStream, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, metaStreamEvent);
        }
        if (!inputStream.getStreamHandlers().isEmpty() && windowDefinitionMap != null && windowDefinitionMap.containsKey(inputStream.getStreamId())) {
            for (StreamHandler handler : inputStream.getStreamHandlers()) {
                if (!(handler instanceof Window)) continue;
                throw new OperationNotSupportedException("Cannot create " + ((Window)handler).getFunction() + " window for the window stream " + inputStream.getStreamId());
            }
        }
        if (!inputStream.getStreamHandlers().isEmpty()) {
            for (StreamHandler handler : inputStream.getStreamHandlers()) {
                Processor currentProcessor = SingleInputStreamParser.generateProcessor(handler, metaComplexEvent, variableExpressionExecutors, executionPlanContext, eventTableMap, supportsBatchProcessing, outputExpectsExpiredEvents, queryName);
                if (currentProcessor instanceof SchedulingProcessor) {
                    if (entryValveProcessor == null) {
                        entryValveProcessor = new EntryValveProcessor(executionPlanContext);
                        if (first) {
                            processor = entryValveProcessor;
                            first = false;
                        } else {
                            processor.setToLast(entryValveProcessor);
                        }
                    }
                    Scheduler scheduler = SchedulerParser.parse(executionPlanContext.getScheduledExecutorService(), entryValveProcessor, executionPlanContext);
                    ((SchedulingProcessor)currentProcessor).setScheduler(scheduler);
                }
                if (first) {
                    processor = currentProcessor;
                    first = false;
                    continue;
                }
                processor.setToLast(currentProcessor);
            }
        }
        metaStreamEvent.initializeAfterWindowData();
        return new SingleStreamRuntime(processStreamReceiver, processor, metaComplexEvent);
    }

    public static Processor generateProcessor(StreamHandler streamHandler, MetaComplexEvent metaEvent, List<VariableExpressionExecutor> variableExpressionExecutors, ExecutionPlanContext executionPlanContext, Map<String, EventTable> eventTableMap, boolean supportsBatchProcessing, boolean outputExpectsExpiredEvents, String queryName) {
        ExpressionExecutor[] attributeExpressionExecutors;
        MetaStreamEvent metaStreamEvent;
        Expression[] parameters = streamHandler.getParameters();
        int stateIndex = -1;
        if (metaEvent instanceof MetaStateEvent) {
            stateIndex = ((MetaStateEvent)metaEvent).getStreamEventCount() - 1;
            metaStreamEvent = ((MetaStateEvent)metaEvent).getMetaStreamEvent(stateIndex);
        } else {
            metaStreamEvent = (MetaStreamEvent)metaEvent;
        }
        if (parameters != null) {
            if (parameters.length > 0) {
                attributeExpressionExecutors = new ExpressionExecutor[parameters.length];
                int parametersLength = parameters.length;
                for (int i = 0; i < parametersLength; ++i) {
                    attributeExpressionExecutors[i] = ExpressionParser.parseExpression(parameters[i], metaEvent, stateIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, false, -1, queryName);
                }
            } else {
                List attributeList = metaStreamEvent.getLastInputDefinition().getAttributeList();
                int parameterSize = attributeList.size();
                attributeExpressionExecutors = new ExpressionExecutor[parameterSize];
                for (int i = 0; i < parameterSize; ++i) {
                    attributeExpressionExecutors[i] = ExpressionParser.parseExpression((Expression)new Variable(((Attribute)attributeList.get(i)).getName()), metaEvent, stateIndex, eventTableMap, variableExpressionExecutors, executionPlanContext, false, -1, queryName);
                }
            }
        } else {
            attributeExpressionExecutors = new ExpressionExecutor[]{};
        }
        if (streamHandler instanceof Filter) {
            return new FilterProcessor(attributeExpressionExecutors[0]);
        }
        if (streamHandler instanceof Window) {
            WindowProcessor windowProcessor = streamHandler instanceof Extension ? (WindowProcessor)SiddhiClassLoader.loadExtensionImplementation((Extension)streamHandler, WindowProcessorExtensionHolder.getInstance(executionPlanContext)) : (WindowProcessor)SiddhiClassLoader.loadSiddhiImplementation(((Window)streamHandler).getFunction(), WindowProcessor.class);
            windowProcessor.initProcessor(metaStreamEvent.getLastInputDefinition(), attributeExpressionExecutors, executionPlanContext, outputExpectsExpiredEvents, queryName);
            return windowProcessor;
        }
        if (streamHandler instanceof StreamFunction) {
            block14: {
                if (supportsBatchProcessing) {
                    try {
                        StreamProcessor abstractStreamProcessor = streamHandler instanceof Extension ? (StreamProcessor)SiddhiClassLoader.loadExtensionImplementation((Extension)streamHandler, StreamProcessorExtensionHolder.getInstance(executionPlanContext)) : (StreamProcessor)SiddhiClassLoader.loadSiddhiImplementation(((StreamFunction)streamHandler).getFunction(), StreamProcessor.class);
                        metaStreamEvent.addInputDefinition(abstractStreamProcessor.initProcessor(metaStreamEvent.getLastInputDefinition(), attributeExpressionExecutors, executionPlanContext, outputExpectsExpiredEvents, queryName));
                        return abstractStreamProcessor;
                    }
                    catch (ExecutionPlanCreationException e) {
                        if (e.isClassLoadingIssue()) break block14;
                        throw e;
                    }
                }
            }
            StreamFunctionProcessor abstractStreamProcessor = streamHandler instanceof Extension ? (StreamFunctionProcessor)SiddhiClassLoader.loadExtensionImplementation((Extension)streamHandler, StreamFunctionProcessorExtensionHolder.getInstance(executionPlanContext)) : (StreamFunctionProcessor)SiddhiClassLoader.loadSiddhiImplementation(((StreamFunction)streamHandler).getFunction(), StreamFunctionProcessor.class);
            metaStreamEvent.addInputDefinition(abstractStreamProcessor.initProcessor(metaStreamEvent.getLastInputDefinition(), attributeExpressionExecutors, executionPlanContext, outputExpectsExpiredEvents, queryName));
            return abstractStreamProcessor;
        }
        throw new IllegalStateException(streamHandler.getClass().getName() + " is not supported");
    }

    private static void initMetaStreamEvent(SingleInputStream inputStream, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, MetaStreamEvent metaStreamEvent) {
        String streamId = inputStream.getStreamId();
        if (!inputStream.isInnerStream() && windowDefinitionMap != null && windowDefinitionMap.containsKey(streamId)) {
            AbstractDefinition inputDefinition = windowDefinitionMap.get(streamId);
            if (!metaStreamEvent.getInputDefinitions().contains(inputDefinition)) {
                metaStreamEvent.addInputDefinition(inputDefinition);
            }
        } else if (streamDefinitionMap != null && streamDefinitionMap.containsKey(streamId)) {
            AbstractDefinition inputDefinition = streamDefinitionMap.get(streamId);
            metaStreamEvent.addInputDefinition(inputDefinition);
        } else if (!inputStream.isInnerStream() && tableDefinitionMap != null && tableDefinitionMap.containsKey(streamId)) {
            AbstractDefinition inputDefinition = tableDefinitionMap.get(streamId);
            metaStreamEvent.addInputDefinition(inputDefinition);
        } else {
            throw new ExecutionPlanCreationException("Stream/table definition with ID '" + inputStream.getStreamId() + "' has not been defined");
        }
        if (inputStream.getStreamReferenceId() != null && !inputStream.getStreamId().equals(inputStream.getStreamReferenceId())) {
            metaStreamEvent.setInputReferenceId(inputStream.getStreamReferenceId());
        }
    }
}

