/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.populater.StateEventPopulatorFactory;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.join.JoinStreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.lock.LockSynchronizer;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.parser.InputStreamParser;
import org.wso2.siddhi.core.util.parser.OutputParser;
import org.wso2.siddhi.core.util.parser.SelectorParser;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.window.EventWindow;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateDefinitionException;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamHandler;
import org.wso2.siddhi.query.api.execution.query.input.handler.Window;
import org.wso2.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class QueryParser {
    public static QueryRuntime parse(Query query, ExecutionPlanContext executionPlanContext, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, EventTable> eventTableMap, Map<String, EventWindow> eventWindowMap, LockSynchronizer lockSynchronizer) {
        QueryRuntime queryRuntime;
        ArrayList<VariableExpressionExecutor> executors = new ArrayList<VariableExpressionExecutor>();
        Element nameElement = null;
        LatencyTracker latencyTracker = null;
        LockWrapper lockWrapper = null;
        try {
            OutputRateLimiter outputRateLimiter;
            Element synchronizedElement;
            nameElement = AnnotationHelper.getAnnotationElement((String)"info", (String)"name", (List)query.getAnnotations());
            String queryName = null;
            queryName = nameElement != null ? nameElement.getValue() : "query_" + UUID.randomUUID().toString();
            if (executionPlanContext.isStatsEnabled() && executionPlanContext.getStatisticsManager() != null && nameElement != null) {
                String metricName = executionPlanContext.getSiddhiContext().getStatisticsConfiguration().getMatricPrefix() + "." + "ExecutionPlans" + "." + executionPlanContext.getName() + "." + "Siddhi" + "." + "Queries" + "." + queryName;
                latencyTracker = executionPlanContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createLatencyTracker(metricName, executionPlanContext.getStatisticsManager());
            }
            OutputStream.OutputEventType outputEventType = query.getOutputStream().getOutputEventType();
            boolean outputExpectsExpiredEvents = false;
            if (outputEventType != OutputStream.OutputEventType.CURRENT_EVENTS) {
                outputExpectsExpiredEvents = true;
            }
            StreamRuntime streamRuntime = InputStreamParser.parse(query.getInputStream(), executionPlanContext, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, eventTableMap, eventWindowMap, executors, latencyTracker, outputExpectsExpiredEvents, queryName);
            QuerySelector selector = SelectorParser.parse(query.getSelector(), query.getOutputStream(), executionPlanContext, streamRuntime.getMetaComplexEvent(), eventTableMap, executors, queryName);
            boolean isWindow = query.getInputStream() instanceof JoinInputStream;
            if (!isWindow && query.getInputStream() instanceof SingleInputStream) {
                for (StreamHandler streamHandler : ((SingleInputStream)query.getInputStream()).getStreamHandlers()) {
                    if (!(streamHandler instanceof Window)) continue;
                    isWindow = true;
                    break;
                }
            }
            if ((synchronizedElement = AnnotationHelper.getAnnotationElement((String)"synchronized", null, (List)query.getAnnotations())) != null) {
                if (!"false".equalsIgnoreCase(synchronizedElement.getValue())) {
                    lockWrapper = new LockWrapper("");
                    lockWrapper.setLock(new ReentrantLock());
                }
            } else if (isWindow || !(streamRuntime instanceof SingleStreamRuntime)) {
                if (streamRuntime instanceof JoinStreamRuntime) {
                    MetaStateEvent metaStateEvent = (MetaStateEvent)streamRuntime.getMetaComplexEvent();
                    MetaStreamEvent[] metaStreamEvents = metaStateEvent.getMetaStreamEvents();
                    if (metaStreamEvents[0].isWindowEvent() && metaStreamEvents[1].isWindowEvent()) {
                        LockWrapper rightLockWrapper;
                        LockWrapper leftLockWrapper = eventWindowMap.get(metaStreamEvents[0].getLastInputDefinition().getId()).getLock();
                        if (!leftLockWrapper.equals(rightLockWrapper = eventWindowMap.get(metaStreamEvents[1].getLastInputDefinition().getId()).getLock())) {
                            lockSynchronizer.sync(leftLockWrapper, rightLockWrapper);
                        }
                        lockWrapper = leftLockWrapper;
                    } else if (metaStreamEvents[0].isWindowEvent()) {
                        lockWrapper = eventWindowMap.get(metaStreamEvents[0].getLastInputDefinition().getId()).getLock();
                    } else if (metaStreamEvents[1].isWindowEvent()) {
                        lockWrapper = eventWindowMap.get(metaStreamEvents[1].getLastInputDefinition().getId()).getLock();
                    } else {
                        lockWrapper = new LockWrapper("");
                        lockWrapper.setLock(new ReentrantLock());
                    }
                } else {
                    lockWrapper = new LockWrapper("");
                    lockWrapper.setLock(new ReentrantLock());
                }
            }
            if ((outputRateLimiter = OutputParser.constructOutputRateLimiter(query.getOutputStream().getId(), query.getOutputRate(), query.getSelector().getGroupByList().size() != 0, isWindow, executionPlanContext.getScheduledExecutorService(), executionPlanContext, queryName)) instanceof WrappedSnapshotOutputRateLimiter) {
                selector.setBatchingEnabled(false);
            }
            executionPlanContext.addEternalReferencedHolder(outputRateLimiter);
            OutputCallback outputCallback = OutputParser.constructOutputCallback(query.getOutputStream(), streamRuntime.getMetaComplexEvent().getOutputStreamDefinition(), eventTableMap, eventWindowMap, executionPlanContext, !(streamRuntime instanceof SingleStreamRuntime), queryName);
            QueryParserHelper.reduceMetaComplexEvent(streamRuntime.getMetaComplexEvent());
            QueryParserHelper.updateVariablePosition(streamRuntime.getMetaComplexEvent(), executors);
            QueryParserHelper.initStreamRuntime(streamRuntime, streamRuntime.getMetaComplexEvent(), lockWrapper, queryName);
            selector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(streamRuntime.getMetaComplexEvent()));
            queryRuntime = new QueryRuntime(query, executionPlanContext, streamRuntime, selector, outputRateLimiter, outputCallback, streamRuntime.getMetaComplexEvent(), lockWrapper != null);
            if (outputRateLimiter instanceof WrappedSnapshotOutputRateLimiter) {
                selector.setBatchingEnabled(false);
                ((WrappedSnapshotOutputRateLimiter)outputRateLimiter).init(streamRuntime.getMetaComplexEvent().getOutputStreamDefinition().getAttributeList().size(), selector.getAttributeProcessorList(), streamRuntime.getMetaComplexEvent());
            }
            outputRateLimiter.init(executionPlanContext, lockWrapper, queryName);
        }
        catch (DuplicateDefinitionException e) {
            if (nameElement != null) {
                throw new DuplicateDefinitionException(e.getMessage() + ", when creating query " + nameElement.getValue(), (Throwable)e);
            }
            throw new DuplicateDefinitionException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            if (nameElement != null) {
                throw new ExecutionPlanCreationException(e.getMessage() + ", when creating query " + nameElement.getValue(), e);
            }
            throw new ExecutionPlanCreationException(e.getMessage(), e);
        }
        return queryRuntime;
    }
}

