/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.expression.Expression;

public class SortWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private int lengthToKeep;
    private ArrayList<StreamEvent> sortedWindow = new ArrayList();
    private ArrayList<Object[]> parameterInfo;
    private EventComparator eventComparator;
    private static final String ASC = "asc";
    private static final String DESC = "desc";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.INT) {
            throw new UnsupportedOperationException("The first parameter should be an integer");
        }
        this.lengthToKeep = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()));
        this.parameterInfo = new ArrayList();
        this.eventComparator = new EventComparator();
        int parametersLength = attributeExpressionExecutors.length;
        for (int i = 1; i < parametersLength; ++i) {
            int order;
            if (!(attributeExpressionExecutors[i] instanceof VariableExpressionExecutor)) {
                throw new UnsupportedOperationException("Required a variable, but found a string parameter");
            }
            ExpressionExecutor variableExpressionExecutor = attributeExpressionExecutors[i];
            if (i + 1 < parametersLength && attributeExpressionExecutors[i + 1].getReturnType() == Attribute.Type.STRING) {
                String nextParameter = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[i + 1]).getValue();
                if (nextParameter.equalsIgnoreCase(DESC)) {
                    order = -1;
                    ++i;
                } else {
                    if (!nextParameter.equalsIgnoreCase(ASC)) throw new UnsupportedOperationException("Parameter string literals should only be \"asc\" or \"desc\"");
                    order = 1;
                    ++i;
                }
            } else {
                order = 1;
            }
            this.parameterInfo.add(new Object[]{variableExpressionExecutor, order});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        SortWindowProcessor sortWindowProcessor = this;
        synchronized (sortWindowProcessor) {
            long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
            StreamEvent streamEvent = streamEventChunk.getFirst();
            streamEventChunk.clear();
            while (streamEvent != null) {
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                StreamEvent next = streamEvent.getNext();
                streamEvent.setNext(null);
                streamEventChunk.add(streamEvent);
                this.sortedWindow.add(clonedEvent);
                if (this.sortedWindow.size() > this.lengthToKeep) {
                    Collections.sort(this.sortedWindow, this.eventComparator);
                    StreamEvent expiredEvent = this.sortedWindow.remove(this.sortedWindow.size() - 1);
                    expiredEvent.setTimestamp(currentTime);
                    streamEventChunk.add(expiredEvent);
                }
                streamEvent = next;
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, ArrayList<StreamEvent>>("SortedWindow", this.sortedWindow)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.sortedWindow = (ArrayList)stateEntry.getValue();
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.sortedWindow, this.streamEventCloner);
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return OperatorParser.constructOperator(this.sortedWindow, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.queryName);
    }

    private class EventComparator
    implements Comparator<StreamEvent> {
        private EventComparator() {
        }

        @Override
        public int compare(StreamEvent e1, StreamEvent e2) {
            for (Object[] listItem : SortWindowProcessor.this.parameterInfo) {
                Comparable comparableVariable2;
                int[] variablePosition = ((VariableExpressionExecutor)listItem[0]).getPosition();
                Comparable comparableVariable1 = (Comparable)e1.getAttribute(variablePosition);
                int comparisonResult = comparableVariable1.compareTo(comparableVariable2 = (Comparable)e2.getAttribute(variablePosition));
                if (comparisonResult == 0) continue;
                return (Integer)listItem[1] * comparisonResult;
            }
            return 0;
        }
    }
}

