/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.expression.Expression;

public class LossyFrequentWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private ConcurrentHashMap<String, LossyCount> countMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, StreamEvent> map = new ConcurrentHashMap();
    private VariableExpressionExecutor[] variableExpressionExecutors;
    private int totalCount = 0;
    private double currentBucketId = 1.0;
    private double support;
    private double error;
    private double windowWidth;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.support = Double.parseDouble(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()));
        this.error = attributeExpressionExecutors.length > 1 ? Double.parseDouble(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue())) : this.support / 10.0;
        if (this.support > 1.0 || this.support < 0.0 || this.error > 1.0 || this.error < 0.0) {
            log.error((Object)"Wrong argument has provided, Error executing the window");
        }
        this.variableExpressionExecutors = new VariableExpressionExecutor[attributeExpressionExecutors.length - 2];
        if (attributeExpressionExecutors.length > 2) {
            for (int i = 2; i < attributeExpressionExecutors.length; ++i) {
                this.variableExpressionExecutors[i - 2] = (VariableExpressionExecutor)attributeExpressionExecutors[i];
            }
        }
        this.windowWidth = Math.ceil(1.0 / this.error);
        this.currentBucketId = 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        LossyFrequentWindowProcessor lossyFrequentWindowProcessor = this;
        synchronized (lossyFrequentWindowProcessor) {
            long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
            StreamEvent streamEvent = streamEventChunk.getFirst();
            streamEventChunk.clear();
            while (streamEvent != null) {
                LossyCount lossyCount;
                String currentKey;
                StreamEvent oldEvent;
                StreamEvent next = streamEvent.getNext();
                streamEvent.setNext(null);
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                ++this.totalCount;
                if (this.totalCount != 1) {
                    this.currentBucketId = Math.ceil((double)this.totalCount / this.windowWidth);
                }
                if ((oldEvent = this.map.put(currentKey = this.generateKey(streamEvent), clonedEvent)) != null) {
                    this.countMap.put(currentKey, this.countMap.get(currentKey).incrementCount());
                } else {
                    LossyCount lCount = new LossyCount(1, (int)this.currentBucketId - 1);
                    this.countMap.put(currentKey, lCount);
                }
                ArrayList keys = new ArrayList();
                keys.addAll(this.countMap.keySet());
                for (String key : keys) {
                    lossyCount = this.countMap.get(key);
                    if (!((double)lossyCount.getCount() >= (this.support - this.error) * (double)this.totalCount) || !key.equals(currentKey)) continue;
                    streamEventChunk.add(streamEvent);
                }
                if ((double)this.totalCount % this.windowWidth == 0.0) {
                    keys = new ArrayList();
                    keys.addAll(this.countMap.keySet());
                    for (String key : keys) {
                        lossyCount = this.countMap.get(key);
                        if (!((double)(lossyCount.getCount() + lossyCount.getBucketId()) <= this.currentBucketId)) continue;
                        log.info((Object)("Removing the Event: " + key + " from the window"));
                        this.countMap.remove(key);
                        StreamEvent expirtedEvent = this.map.remove(key);
                        expirtedEvent.setTimestamp(currentTime);
                        streamEventChunk.add(expirtedEvent);
                    }
                }
                streamEvent = next;
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, ConcurrentHashMap<String, LossyCount>>("CountMap", this.countMap)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.countMap = (ConcurrentHashMap)stateEntry.getValue();
    }

    private String generateKey(StreamEvent event) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.variableExpressionExecutors.length == 0) {
            for (Object data : event.getOutputData()) {
                stringBuilder.append(data);
            }
        } else {
            for (VariableExpressionExecutor executor : this.variableExpressionExecutors) {
                stringBuilder.append(event.getAttribute(executor.getPosition()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.map.values(), this.streamEventCloner);
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return OperatorParser.constructOperator(this.map.values(), expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.queryName);
    }

    public class LossyCount {
        int count;
        int bucketId;

        public LossyCount(int count, int bucketId) {
            this.count = count;
            this.bucketId = bucketId;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public void setBucketId(int bucketId) {
            this.bucketId = bucketId;
        }

        public LossyCount incrementCount() {
            ++this.count;
            return this;
        }
    }
}

