/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.expression.Expression;

public class FrequentWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private ConcurrentHashMap<String, Integer> countMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, StreamEvent> map = new ConcurrentHashMap();
    private VariableExpressionExecutor[] variableExpressionExecutors;
    private int mostFrequentCount;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.mostFrequentCount = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()));
        this.variableExpressionExecutors = new VariableExpressionExecutor[attributeExpressionExecutors.length - 1];
        for (int i = 1; i < attributeExpressionExecutors.length; ++i) {
            this.variableExpressionExecutors[i - 1] = (VariableExpressionExecutor)attributeExpressionExecutors[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        FrequentWindowProcessor frequentWindowProcessor = this;
        synchronized (frequentWindowProcessor) {
            StreamEvent streamEvent = streamEventChunk.getFirst();
            streamEventChunk.clear();
            long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
            while (streamEvent != null) {
                StreamEvent next = streamEvent.getNext();
                streamEvent.setNext(null);
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                String key = this.generateKey(streamEvent);
                StreamEvent oldEvent = this.map.put(key, clonedEvent);
                if (oldEvent != null) {
                    this.countMap.put(key, this.countMap.get(key) + 1);
                    streamEventChunk.add(streamEvent);
                } else if (this.map.size() > this.mostFrequentCount) {
                    ArrayList keys = new ArrayList(this.countMap.keySet());
                    for (int i = 0; i < this.mostFrequentCount; ++i) {
                        int count = this.countMap.get(keys.get(i)) - 1;
                        if (count == 0) {
                            this.countMap.remove(keys.get(i));
                            StreamEvent expiredEvent = this.map.remove(keys.get(i));
                            expiredEvent.setTimestamp(currentTime);
                            streamEventChunk.add(expiredEvent);
                            continue;
                        }
                        this.countMap.put((String)keys.get(i), count);
                    }
                    if (this.map.size() > this.mostFrequentCount) {
                        this.map.remove(key);
                    } else {
                        this.countMap.put(key, 1);
                        streamEventChunk.add(streamEvent);
                    }
                } else {
                    this.countMap.put(this.generateKey(streamEvent), 1);
                    streamEventChunk.add(streamEvent);
                }
                streamEvent = next;
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, ConcurrentHashMap<String, Integer>>("CountMap", this.countMap)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.countMap = (ConcurrentHashMap)stateEntry.getValue();
    }

    private String generateKey(StreamEvent event) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.variableExpressionExecutors.length == 0) {
            for (Object data : event.getOutputData()) {
                stringBuilder.append(data);
            }
        } else {
            for (VariableExpressionExecutor executor : this.variableExpressionExecutors) {
                stringBuilder.append(event.getAttribute(executor.getPosition()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.map.values(), this.streamEventCloner);
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return OperatorParser.constructOperator(this.map.values(), expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.queryName);
    }
}

