/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.callback;

import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class InsertIntoTableCallback
extends OutputCallback {
    private EventTable eventTable;
    private StreamDefinition outputStreamDefinition;
    private boolean convertToStreamEvent;
    private StreamEventPool streamEventPool;
    private StreamEventConverter streamEventConverter;

    public InsertIntoTableCallback(EventTable eventTable, StreamDefinition outputStreamDefinition, boolean convertToStreamEvent, StreamEventPool streamEventPool, StreamEventConverter streamEventConverter, String queryName) {
        super(queryName);
        this.eventTable = eventTable;
        this.outputStreamDefinition = outputStreamDefinition;
        this.convertToStreamEvent = convertToStreamEvent;
        this.streamEventPool = streamEventPool;
        this.streamEventConverter = streamEventConverter;
    }

    @Override
    public void send(ComplexEventChunk complexEventChunk) {
        if (this.getDebugger() != null) {
            this.getDebugger().checkBreakPoint(this.getQueryName(), SiddhiDebugger.QueryTerminal.OUT, (ComplexEvent)complexEventChunk.getFirst());
        }
        if (this.convertToStreamEvent) {
            ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>(complexEventChunk.isBatch());
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                StreamEvent borrowEvent = this.streamEventPool.borrowEvent();
                this.streamEventConverter.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType() == ComplexEvent.Type.EXPIRED ? ComplexEvent.Type.CURRENT : complexEvent.getType(), borrowEvent);
                streamEventChunk.add(borrowEvent);
            }
            this.eventTable.add(streamEventChunk);
        } else {
            complexEventChunk.reset();
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                if (complexEvent.getType() != ComplexEvent.Type.EXPIRED) continue;
                complexEvent.setType(ComplexEvent.Type.CURRENT);
            }
            this.eventTable.add(complexEventChunk);
        }
    }

    public StreamDefinition getOutputStreamDefinition() {
        return this.outputStreamDefinition;
    }
}

