/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.join;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.join.JoinProcessor;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;

public class JoinStreamRuntime
implements StreamRuntime {
    List<SingleStreamRuntime> singleStreamRuntimeList = new ArrayList<SingleStreamRuntime>();
    private ExecutionPlanContext executionPlanContext;
    private MetaStateEvent metaStateEvent;

    public JoinStreamRuntime(ExecutionPlanContext executionPlanContext, MetaStateEvent metaStateEvent) {
        this.executionPlanContext = executionPlanContext;
        this.metaStateEvent = metaStateEvent;
    }

    public void addRuntime(SingleStreamRuntime singleStreamRuntime) {
        this.singleStreamRuntimeList.add(singleStreamRuntime);
    }

    @Override
    public List<SingleStreamRuntime> getSingleStreamRuntimes() {
        return this.singleStreamRuntimeList;
    }

    @Override
    public StreamRuntime clone(String key) {
        JoinStreamRuntime joinStreamRuntime = new JoinStreamRuntime(this.executionPlanContext, this.metaStateEvent);
        for (SingleStreamRuntime singleStreamRuntime : this.singleStreamRuntimeList) {
            joinStreamRuntime.addRuntime((SingleStreamRuntime)singleStreamRuntime.clone(key));
        }
        SingleStreamRuntime leftSingleStreamRuntime = joinStreamRuntime.getSingleStreamRuntimes().get(0);
        SingleStreamRuntime rightSingleStreamRuntime = joinStreamRuntime.getSingleStreamRuntimes().get(1);
        Processor lastLeftProcessor = leftSingleStreamRuntime.getProcessorChain();
        while (!(lastLeftProcessor instanceof JoinProcessor)) {
            lastLeftProcessor = lastLeftProcessor.getNextProcessor();
        }
        JoinProcessor leftPreJoinProcessor = (JoinProcessor)lastLeftProcessor;
        WindowProcessor leftWindowProcessor = (WindowProcessor)leftPreJoinProcessor.getNextProcessor();
        JoinProcessor leftPostJoinProcessor = (JoinProcessor)leftWindowProcessor.getNextProcessor();
        Processor lastRightProcessor = rightSingleStreamRuntime.getProcessorChain();
        while (!(lastRightProcessor instanceof JoinProcessor)) {
            lastRightProcessor = lastRightProcessor.getNextProcessor();
        }
        JoinProcessor rightPreJoinProcessor = (JoinProcessor)lastRightProcessor;
        WindowProcessor rightWindowProcessor = (WindowProcessor)rightPreJoinProcessor.getNextProcessor();
        JoinProcessor rightPostJoinProcessor = (JoinProcessor)rightWindowProcessor.getNextProcessor();
        rightPostJoinProcessor.setFindableProcessor((FindableProcessor)((Object)leftWindowProcessor));
        rightPreJoinProcessor.setFindableProcessor((FindableProcessor)((Object)leftWindowProcessor));
        leftPreJoinProcessor.setFindableProcessor((FindableProcessor)((Object)rightWindowProcessor));
        leftPostJoinProcessor.setFindableProcessor((FindableProcessor)((Object)rightWindowProcessor));
        return joinStreamRuntime;
    }

    @Override
    public void setCommonProcessor(Processor commonProcessor) {
        for (SingleStreamRuntime singleStreamRuntime : this.singleStreamRuntimeList) {
            singleStreamRuntime.setCommonProcessor(commonProcessor);
        }
    }

    @Override
    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaStateEvent;
    }
}

