/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.partition;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.partition.PartitionInstanceRuntime;
import org.wso2.siddhi.core.partition.PartitionStreamReceiver;
import org.wso2.siddhi.core.partition.StreamPartitioner;
import org.wso2.siddhi.core.partition.executor.PartitionExecutor;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.query.input.stream.join.JoinStreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.input.stream.state.StateStreamRuntime;
import org.wso2.siddhi.core.query.output.callback.InsertIntoStreamCallback;
import org.wso2.siddhi.core.query.output.callback.InsertIntoWindowCallback;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.util.parser.helper.DefinitionParserHelper;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.input.state.CountStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.EveryStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.NextStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class PartitionRuntime
implements Snapshotable {
    private String partitionId;
    private String elementId;
    private Partition partition;
    private ConcurrentMap<String, StreamJunction> localStreamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();
    private ConcurrentMap<String, AbstractDefinition> localStreamDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, AbstractDefinition> streamDefinitionMap;
    private ConcurrentMap<String, StreamJunction> streamJunctionMap;
    private ConcurrentMap<String, QueryRuntime> metaQueryRuntimeMap = new ConcurrentHashMap<String, QueryRuntime>();
    private ConcurrentMap<String, PartitionInstanceRuntime> partitionInstanceRuntimeMap = new ConcurrentHashMap<String, PartitionInstanceRuntime>();
    private ConcurrentMap<String, PartitionStreamReceiver> partitionStreamReceivers = new ConcurrentHashMap<String, PartitionStreamReceiver>();
    private ExecutionPlanContext executionPlanContext;

    public PartitionRuntime(ConcurrentMap<String, AbstractDefinition> streamDefinitionMap, ConcurrentMap<String, StreamJunction> streamJunctionMap, Partition partition, ExecutionPlanContext executionPlanContext) {
        if (partition.getPartitionTypeMap().isEmpty()) {
            throw new ExecutionPlanCreationException("Partition must have at least one partition key. But found none.");
        }
        this.executionPlanContext = executionPlanContext;
        Element element = AnnotationHelper.getAnnotationElement((String)"info", (String)"name", (List)partition.getAnnotations());
        if (element != null) {
            this.partitionId = element.getValue();
        }
        if (this.partitionId == null) {
            this.partitionId = UUID.randomUUID().toString();
        }
        this.elementId = "PartitionRuntime-" + executionPlanContext.getElementIdGenerator().createNewId();
        this.partition = partition;
        this.streamDefinitionMap = streamDefinitionMap;
        this.streamJunctionMap = streamJunctionMap;
    }

    public QueryRuntime addQuery(QueryRuntime metaQueryRuntime) {
        Query query = metaQueryRuntime.getQuery();
        if (query.getOutputStream() instanceof InsertIntoStream && metaQueryRuntime.getOutputCallback() instanceof InsertIntoStreamCallback) {
            InsertIntoStreamCallback insertIntoStreamCallback = (InsertIntoStreamCallback)metaQueryRuntime.getOutputCallback();
            StreamDefinition streamDefinition = insertIntoStreamCallback.getOutputStreamDefinition();
            String id = streamDefinition.getId();
            if (((InsertIntoStream)query.getOutputStream()).isInnerStream()) {
                metaQueryRuntime.setToLocalStream(true);
                this.localStreamDefinitionMap.putIfAbsent(id, (AbstractDefinition)streamDefinition);
                DefinitionParserHelper.validateOutputStream(streamDefinition, (AbstractDefinition)this.localStreamDefinitionMap.get(id));
                StreamJunction outputStreamJunction = (StreamJunction)this.localStreamJunctionMap.get(id);
                if (outputStreamJunction == null) {
                    outputStreamJunction = new StreamJunction(streamDefinition, this.executionPlanContext.getExecutorService(), this.executionPlanContext.getBufferSize(), this.executionPlanContext);
                    this.localStreamJunctionMap.putIfAbsent(id, outputStreamJunction);
                }
                insertIntoStreamCallback.init((StreamJunction)this.localStreamJunctionMap.get(id));
            } else {
                this.streamDefinitionMap.putIfAbsent(id, (AbstractDefinition)streamDefinition);
                DefinitionParserHelper.validateOutputStream(streamDefinition, (AbstractDefinition)this.streamDefinitionMap.get(id));
                StreamJunction outputStreamJunction = (StreamJunction)this.streamJunctionMap.get(id);
                if (outputStreamJunction == null) {
                    outputStreamJunction = new StreamJunction(streamDefinition, this.executionPlanContext.getExecutorService(), this.executionPlanContext.getBufferSize(), this.executionPlanContext);
                    this.streamJunctionMap.putIfAbsent(id, outputStreamJunction);
                }
                insertIntoStreamCallback.init((StreamJunction)this.streamJunctionMap.get(id));
            }
        } else if (query.getOutputStream() instanceof InsertIntoStream && metaQueryRuntime.getOutputCallback() instanceof InsertIntoWindowCallback) {
            InsertIntoWindowCallback insertIntoWindowCallback = (InsertIntoWindowCallback)metaQueryRuntime.getOutputCallback();
            StreamDefinition streamDefinition = insertIntoWindowCallback.getOutputStreamDefinition();
            String id = streamDefinition.getId();
            this.streamDefinitionMap.putIfAbsent(id, (AbstractDefinition)streamDefinition);
            DefinitionParserHelper.validateOutputStream(streamDefinition, (AbstractDefinition)this.streamDefinitionMap.get(id));
            StreamJunction outputStreamJunction = (StreamJunction)this.streamJunctionMap.get(id);
            if (outputStreamJunction == null) {
                outputStreamJunction = new StreamJunction(streamDefinition, this.executionPlanContext.getExecutorService(), this.executionPlanContext.getBufferSize(), this.executionPlanContext);
                this.streamJunctionMap.putIfAbsent(id, outputStreamJunction);
            }
            insertIntoWindowCallback.getEventWindow().setPublisher(((StreamJunction)this.streamJunctionMap.get(id)).constructPublisher());
        }
        this.metaQueryRuntimeMap.put(metaQueryRuntime.getQueryId(), metaQueryRuntime);
        return metaQueryRuntime;
    }

    public void addPartitionReceiver(QueryRuntime queryRuntime, List<VariableExpressionExecutor> executors, MetaStateEvent metaEvent) {
        Query query = queryRuntime.getQuery();
        List<List<PartitionExecutor>> partitionExecutors = new StreamPartitioner(query.getInputStream(), this.partition, metaEvent, executors, this.executionPlanContext, null).getPartitionExecutorLists();
        if (queryRuntime.getStreamRuntime() instanceof SingleStreamRuntime) {
            SingleInputStream singleInputStream = (SingleInputStream)query.getInputStream();
            this.addPartitionReceiver(singleInputStream.getStreamId(), singleInputStream.isInnerStream(), metaEvent.getMetaStreamEvent(0), partitionExecutors.get(0));
        } else if (queryRuntime.getStreamRuntime() instanceof JoinStreamRuntime) {
            SingleInputStream leftSingleInputStream = (SingleInputStream)((JoinInputStream)query.getInputStream()).getLeftInputStream();
            this.addPartitionReceiver(leftSingleInputStream.getStreamId(), leftSingleInputStream.isInnerStream(), metaEvent.getMetaStreamEvent(0), partitionExecutors.get(0));
            SingleInputStream rightSingleInputStream = (SingleInputStream)((JoinInputStream)query.getInputStream()).getRightInputStream();
            this.addPartitionReceiver(rightSingleInputStream.getStreamId(), rightSingleInputStream.isInnerStream(), metaEvent.getMetaStreamEvent(1), partitionExecutors.get(1));
        } else if (queryRuntime.getStreamRuntime() instanceof StateStreamRuntime) {
            StateElement stateElement = ((StateInputStream)query.getInputStream()).getStateElement();
            this.addPartitionReceiverForStateElement(stateElement, metaEvent, partitionExecutors, 0);
        }
    }

    private int addPartitionReceiverForStateElement(StateElement stateElement, MetaStateEvent metaEvent, List<List<PartitionExecutor>> partitionExecutors, int executorIndex) {
        if (stateElement instanceof EveryStateElement) {
            return this.addPartitionReceiverForStateElement(((EveryStateElement)stateElement).getStateElement(), metaEvent, partitionExecutors, executorIndex);
        }
        if (stateElement instanceof NextStateElement) {
            executorIndex = this.addPartitionReceiverForStateElement(((NextStateElement)stateElement).getStateElement(), metaEvent, partitionExecutors, executorIndex);
            return this.addPartitionReceiverForStateElement(((NextStateElement)stateElement).getNextStateElement(), metaEvent, partitionExecutors, executorIndex);
        }
        if (stateElement instanceof CountStateElement) {
            return this.addPartitionReceiverForStateElement((StateElement)((CountStateElement)stateElement).getStreamStateElement(), metaEvent, partitionExecutors, executorIndex);
        }
        if (stateElement instanceof LogicalStateElement) {
            executorIndex = this.addPartitionReceiverForStateElement((StateElement)((LogicalStateElement)stateElement).getStreamStateElement1(), metaEvent, partitionExecutors, executorIndex);
            return this.addPartitionReceiverForStateElement((StateElement)((LogicalStateElement)stateElement).getStreamStateElement2(), metaEvent, partitionExecutors, executorIndex);
        }
        BasicSingleInputStream singleInputStream = ((StreamStateElement)stateElement).getBasicSingleInputStream();
        this.addPartitionReceiver(singleInputStream.getStreamId(), singleInputStream.isInnerStream(), metaEvent.getMetaStreamEvent(executorIndex), partitionExecutors.get(executorIndex));
        return ++executorIndex;
    }

    private void addPartitionReceiver(String streamId, boolean isInnerStream, MetaStreamEvent metaStreamEvent, List<PartitionExecutor> partitionExecutors) {
        if (!(this.partitionStreamReceivers.containsKey(streamId) || isInnerStream || metaStreamEvent.isTableEvent() || metaStreamEvent.isWindowEvent())) {
            PartitionStreamReceiver partitionStreamReceiver = new PartitionStreamReceiver(this.executionPlanContext, metaStreamEvent, (StreamDefinition)this.streamDefinitionMap.get(streamId), partitionExecutors, this);
            this.partitionStreamReceivers.put(partitionStreamReceiver.getStreamId(), partitionStreamReceiver);
            ((StreamJunction)this.streamJunctionMap.get(partitionStreamReceiver.getStreamId())).subscribe(partitionStreamReceiver);
        }
    }

    public void cloneIfNotExist(String key) {
        if (!this.partitionInstanceRuntimeMap.containsKey(key)) {
            this.clonePartition(key);
        }
    }

    private synchronized void clonePartition(String key) {
        PartitionInstanceRuntime partitionInstance = (PartitionInstanceRuntime)this.partitionInstanceRuntimeMap.get(key);
        if (partitionInstance == null) {
            ArrayList<QueryRuntime> queryRuntimeList = new ArrayList<QueryRuntime>();
            CopyOnWriteArrayList<QueryRuntime> partitionedQueryRuntimeList = new CopyOnWriteArrayList<QueryRuntime>();
            for (QueryRuntime queryRuntime : this.metaQueryRuntimeMap.values()) {
                QueryRuntime clonedQueryRuntime = queryRuntime.clone(key, this.localStreamJunctionMap);
                queryRuntimeList.add(clonedQueryRuntime);
                if (queryRuntime.isFromLocalStream()) {
                    for (int i = 0; i < clonedQueryRuntime.getStreamRuntime().getSingleStreamRuntimes().size(); ++i) {
                        String streamId = queryRuntime.getStreamRuntime().getSingleStreamRuntimes().get(i).getProcessStreamReceiver().getStreamId();
                        StreamDefinition streamDefinition = streamId.startsWith("#") ? (StreamDefinition)this.localStreamDefinitionMap.get(streamId) : (StreamDefinition)this.streamDefinitionMap.get(streamId);
                        StreamJunction streamJunction = (StreamJunction)this.localStreamJunctionMap.get(streamId + key);
                        if (streamJunction == null) {
                            streamJunction = new StreamJunction(streamDefinition, this.executionPlanContext.getExecutorService(), this.executionPlanContext.getBufferSize(), this.executionPlanContext);
                            this.localStreamJunctionMap.put(streamId + key, streamJunction);
                        }
                        streamJunction.subscribe(clonedQueryRuntime.getStreamRuntime().getSingleStreamRuntimes().get(i).getProcessStreamReceiver());
                    }
                    continue;
                }
                partitionedQueryRuntimeList.add(clonedQueryRuntime);
            }
            this.partitionInstanceRuntimeMap.putIfAbsent(key, new PartitionInstanceRuntime(key, queryRuntimeList));
            this.updatePartitionStreamReceivers(key, partitionedQueryRuntimeList);
        }
    }

    private void updatePartitionStreamReceivers(String key, List<QueryRuntime> partitionedQueryRuntimeList) {
        for (PartitionStreamReceiver partitionStreamReceiver : this.partitionStreamReceivers.values()) {
            partitionStreamReceiver.addStreamJunction(key, partitionedQueryRuntimeList);
        }
    }

    public void addStreamJunction(String key, StreamJunction streamJunction) {
        this.localStreamJunctionMap.put(key, streamJunction);
    }

    public void init() {
        for (PartitionStreamReceiver partitionStreamReceiver : this.partitionStreamReceivers.values()) {
            partitionStreamReceiver.init();
        }
        this.executionPlanContext.getSnapshotService().addSnapshotable(this.partitionId, this);
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public ConcurrentMap<String, QueryRuntime> getMetaQueryRuntimeMap() {
        return this.metaQueryRuntimeMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getLocalStreamDefinitionMap() {
        return this.localStreamDefinitionMap;
    }

    public ConcurrentMap<String, StreamJunction> getLocalStreamJunctionMap() {
        return this.localStreamJunctionMap;
    }

    @Override
    public Object[] currentState() {
        ArrayList partitionKeys = new ArrayList(this.partitionInstanceRuntimeMap.keySet());
        return new Object[]{partitionKeys};
    }

    @Override
    public void restoreState(Object[] state) {
        List partitionKeys = (List)state[0];
        for (String key : partitionKeys) {
            this.clonePartition(key);
        }
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

