/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.event.stream.converter;

import java.util.List;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;

public class SelectiveStreamEventConverter
implements StreamEventConverter {
    private List<StreamEventConverter.ConversionMapping> conversionMappings;

    public SelectiveStreamEventConverter(List<StreamEventConverter.ConversionMapping> conversionMappings) {
        this.conversionMappings = conversionMappings;
    }

    @Override
    public void convertData(long timestamp, Object[] data, ComplexEvent.Type type, StreamEvent borrowedEvent) {
        for (StreamEventConverter.ConversionMapping conversionMapping : this.conversionMappings) {
            int[] position = conversionMapping.getToPosition();
            int fromPosition = conversionMapping.getFromPosition();
            switch (position[0]) {
                case 0: {
                    borrowedEvent.setBeforeWindowData(data[fromPosition], position[1]);
                    break;
                }
                case 1: {
                    borrowedEvent.setOnAfterWindowData(data[fromPosition], position[1]);
                    break;
                }
                case 2: {
                    borrowedEvent.setOutputData(data[fromPosition], position[1]);
                    break;
                }
            }
        }
        borrowedEvent.setType(type);
        borrowedEvent.setTimestamp(timestamp);
    }

    @Override
    public void convertEvent(Event event, StreamEvent borrowedEvent) {
        this.convertData(event.getTimestamp(), event.getData(), event.isExpired() ? ComplexEvent.Type.EXPIRED : ComplexEvent.Type.CURRENT, borrowedEvent);
    }

    @Override
    public void convertComplexEvent(ComplexEvent complexEvent, StreamEvent borrowedEvent) {
        this.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType(), borrowedEvent);
    }

    @Override
    public void convertData(long timeStamp, Object[] data, StreamEvent borrowedEvent) {
        this.convertData(timeStamp, data, ComplexEvent.Type.CURRENT, borrowedEvent);
    }
}

