/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import org.wso2.siddhi.core.exception.DefinitionNotExistException;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.query.output.callback.DeleteTableCallback;
import org.wso2.siddhi.core.query.output.callback.InsertIntoStreamCallback;
import org.wso2.siddhi.core.query.output.callback.InsertIntoTableCallback;
import org.wso2.siddhi.core.query.output.callback.InsertIntoWindowCallback;
import org.wso2.siddhi.core.query.output.callback.InsertOverwriteTableCallback;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.callback.UpdateTableCallback;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.PassThroughOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.event.AllPerEventOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.event.FirstGroupByPerEventOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.event.FirstPerEventOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.event.LastGroupByPerEventOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.event.LastPerEventOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.time.AllPerTimeOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.time.FirstGroupByPerTimeOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.time.FirstPerTimeOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.time.LastGroupByPerTimeOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.time.LastPerTimeOutputRateLimiter;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.MatcherParser;
import org.wso2.siddhi.core.util.parser.helper.DefinitionParserHelper;
import org.wso2.siddhi.core.window.EventWindow;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.EventOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.OutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.SnapshotOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.TimeOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.stream.DeleteStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.InsertOverwriteStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateStream;

public class OutputParser {
    public static OutputCallback constructOutputCallback(OutputStream outStream, StreamDefinition outputStreamDefinition, Map<String, EventTable> eventTableMap, Map<String, EventWindow> eventWindowMap, ExecutionPlanContext executionPlanContext, boolean convertToStreamEvent, String queryName) {
        String id = outStream.getId();
        EventTable eventTable = eventTableMap.get(id);
        EventWindow eventWindow = eventWindowMap.get(id);
        StreamEventPool streamEventPool = null;
        ZeroStreamEventConverter streamEventConvertor = null;
        MetaStreamEvent tableMetaStreamEvent = null;
        if (eventTable != null) {
            tableMetaStreamEvent = new MetaStreamEvent();
            tableMetaStreamEvent.setTableEvent(true);
            TableDefinition matchingTableDefinition = TableDefinition.id((String)"");
            for (Attribute attribute : outputStreamDefinition.getAttributeList()) {
                tableMetaStreamEvent.addOutputData(attribute);
                matchingTableDefinition.attribute(attribute.getName(), attribute.getType());
            }
            tableMetaStreamEvent.addInputDefinition((AbstractDefinition)matchingTableDefinition);
            streamEventPool = new StreamEventPool(tableMetaStreamEvent, 10);
            streamEventConvertor = new ZeroStreamEventConverter();
        }
        if (outStream instanceof InsertIntoStream) {
            if (eventWindow != null) {
                return new InsertIntoWindowCallback(eventWindow, outputStreamDefinition, queryName);
            }
            if (eventTable != null) {
                DefinitionParserHelper.validateOutputStream(outputStreamDefinition, (AbstractDefinition)eventTable.getTableDefinition());
                return new InsertIntoTableCallback(eventTable, outputStreamDefinition, convertToStreamEvent, streamEventPool, streamEventConvertor, queryName);
            }
            return new InsertIntoStreamCallback(outputStreamDefinition, queryName);
        }
        if (outStream instanceof DeleteStream || outStream instanceof UpdateStream || outStream instanceof InsertOverwriteStream) {
            if (eventTable != null) {
                StateEventPool stateEventPool;
                Operator operator;
                MatchingMetaStateHolder matchingMetaStateHolder;
                if (outStream instanceof UpdateStream || outStream instanceof InsertOverwriteStream) {
                    TableDefinition eventTableDefinition = eventTable.getTableDefinition();
                    for (Attribute attribute : outputStreamDefinition.getAttributeList()) {
                        if (eventTableDefinition.getAttributeList().contains(attribute)) continue;
                        throw new ExecutionPlanCreationException("Attribute " + attribute + " does not exist on Event Table " + eventTableDefinition);
                    }
                }
                if (outStream instanceof DeleteStream) {
                    try {
                        matchingMetaStateHolder = MatcherParser.constructMatchingMetaStateHolder(tableMetaStreamEvent, 0, (AbstractDefinition)eventTable.getTableDefinition());
                        operator = eventTable.constructOperator(((DeleteStream)outStream).getOnDeleteExpression(), matchingMetaStateHolder, executionPlanContext, null, eventTableMap);
                        stateEventPool = new StateEventPool(matchingMetaStateHolder.getMetaStateEvent(), 10);
                        return new DeleteTableCallback(eventTable, operator, matchingMetaStateHolder.getDefaultStreamEventIndex(), convertToStreamEvent, stateEventPool, streamEventPool, streamEventConvertor, queryName);
                    }
                    catch (ExecutionPlanValidationException e) {
                        throw new ExecutionPlanCreationException("Cannot create delete for table '" + outStream.getId() + "', " + e.getMessage(), e);
                    }
                }
                if (outStream instanceof UpdateStream) {
                    try {
                        matchingMetaStateHolder = MatcherParser.constructMatchingMetaStateHolder(tableMetaStreamEvent, 0, (AbstractDefinition)eventTable.getTableDefinition());
                        operator = eventTable.constructOperator(((UpdateStream)outStream).getOnUpdateExpression(), matchingMetaStateHolder, executionPlanContext, null, eventTableMap);
                        stateEventPool = new StateEventPool(matchingMetaStateHolder.getMetaStateEvent(), 10);
                        return new UpdateTableCallback(eventTable, operator, (AbstractDefinition)outputStreamDefinition, matchingMetaStateHolder.getDefaultStreamEventIndex(), convertToStreamEvent, stateEventPool, streamEventPool, streamEventConvertor, queryName);
                    }
                    catch (ExecutionPlanValidationException e) {
                        throw new ExecutionPlanCreationException("Cannot create update for table '" + outStream.getId() + "', " + e.getMessage(), e);
                    }
                }
                DefinitionParserHelper.validateOutputStream(outputStreamDefinition, (AbstractDefinition)eventTable.getTableDefinition());
                try {
                    matchingMetaStateHolder = MatcherParser.constructMatchingMetaStateHolder(tableMetaStreamEvent, 0, (AbstractDefinition)eventTable.getTableDefinition());
                    operator = eventTable.constructOperator(((InsertOverwriteStream)outStream).getOnOverwriteExpression(), matchingMetaStateHolder, executionPlanContext, null, eventTableMap);
                    stateEventPool = new StateEventPool(matchingMetaStateHolder.getMetaStateEvent(), 10);
                    return new InsertOverwriteTableCallback(eventTable, operator, (AbstractDefinition)outputStreamDefinition, matchingMetaStateHolder.getDefaultStreamEventIndex(), convertToStreamEvent, stateEventPool, streamEventPool, streamEventConvertor, queryName);
                }
                catch (ExecutionPlanValidationException e) {
                    throw new ExecutionPlanCreationException("Cannot create insert overwrite for table '" + outStream.getId() + "', " + e.getMessage(), e);
                }
            }
            throw new DefinitionNotExistException("Event table with id :" + id + " does not exist");
        }
        throw new ExecutionPlanCreationException(outStream.getClass().getName() + " not supported");
    }

    public static OutputCallback constructOutputCallback(OutputStream outStream, String key, ConcurrentMap<String, StreamJunction> streamJunctionMap, StreamDefinition outputStreamDefinition, ExecutionPlanContext executionPlanContext, String queryName) {
        String id = outStream.getId();
        if (outStream instanceof InsertIntoStream) {
            StreamJunction outputStreamJunction = (StreamJunction)streamJunctionMap.get(id + key);
            if (outputStreamJunction == null) {
                outputStreamJunction = new StreamJunction(outputStreamDefinition, executionPlanContext.getExecutorService(), executionPlanContext.getBufferSize(), executionPlanContext);
                streamJunctionMap.putIfAbsent(id + key, outputStreamJunction);
            }
            InsertIntoStreamCallback insertIntoStreamCallback = new InsertIntoStreamCallback(outputStreamDefinition, queryName);
            insertIntoStreamCallback.init((StreamJunction)streamJunctionMap.get(id + key));
            return insertIntoStreamCallback;
        }
        throw new ExecutionPlanCreationException(outStream.getClass().getName() + " not supported");
    }

    public static OutputRateLimiter constructOutputRateLimiter(String id, OutputRate outputRate, boolean isGroupBy, boolean isWindow, ScheduledExecutorService scheduledExecutorService, ExecutionPlanContext executionPlanContext, String queryName) {
        if (outputRate == null) {
            return new PassThroughOutputRateLimiter(id);
        }
        if (outputRate instanceof EventOutputRate) {
            switch (((EventOutputRate)outputRate).getType()) {
                case ALL: {
                    return new AllPerEventOutputRateLimiter(id, ((EventOutputRate)outputRate).getValue());
                }
                case FIRST: {
                    if (isGroupBy) {
                        return new FirstGroupByPerEventOutputRateLimiter(id, ((EventOutputRate)outputRate).getValue());
                    }
                    return new FirstPerEventOutputRateLimiter(id, ((EventOutputRate)outputRate).getValue());
                }
                case LAST: {
                    if (isGroupBy) {
                        return new LastGroupByPerEventOutputRateLimiter(id, ((EventOutputRate)outputRate).getValue());
                    }
                    return new LastPerEventOutputRateLimiter(id, ((EventOutputRate)outputRate).getValue());
                }
            }
            throw new OperationNotSupportedException(((EventOutputRate)outputRate).getType() + " not supported in output rate limiting");
        }
        if (outputRate instanceof TimeOutputRate) {
            switch (((TimeOutputRate)outputRate).getType()) {
                case ALL: {
                    return new AllPerTimeOutputRateLimiter(id, ((TimeOutputRate)outputRate).getValue(), scheduledExecutorService, queryName);
                }
                case FIRST: {
                    if (isGroupBy) {
                        return new FirstGroupByPerTimeOutputRateLimiter(id, ((TimeOutputRate)outputRate).getValue(), scheduledExecutorService, queryName);
                    }
                    return new FirstPerTimeOutputRateLimiter(id, ((TimeOutputRate)outputRate).getValue(), scheduledExecutorService, queryName);
                }
                case LAST: {
                    if (isGroupBy) {
                        return new LastGroupByPerTimeOutputRateLimiter(id, ((TimeOutputRate)outputRate).getValue(), scheduledExecutorService, queryName);
                    }
                    return new LastPerTimeOutputRateLimiter(id, ((TimeOutputRate)outputRate).getValue(), scheduledExecutorService, queryName);
                }
            }
            throw new OperationNotSupportedException(((TimeOutputRate)outputRate).getType() + " not supported in output rate limiting");
        }
        return new WrappedSnapshotOutputRateLimiter(id, ((SnapshotOutputRate)outputRate).getValue(), scheduledExecutorService, isGroupBy, isWindow, executionPlanContext, queryName);
    }
}

