/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.table.holder.PrimaryKeyEventHolder;
import org.wso2.siddhi.core.util.collection.operator.CollectionOperator;
import org.wso2.siddhi.core.util.collection.operator.EventChunkOperator;
import org.wso2.siddhi.core.util.collection.operator.MapOperator;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.collection.operator.PrimaryKeyOperator;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.constant.Constant;

public class OperatorParser {
    public static Operator constructOperator(Object candidateEvents, Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap, String queryName) {
        if (candidateEvents instanceof PrimaryKeyEventHolder) {
            Compare compare;
            if (expression instanceof Compare && ((Compare)expression).getOperator() == Compare.Operator.EQUAL && ((compare = (Compare)expression).getLeftExpression() instanceof Variable || compare.getLeftExpression() instanceof Constant) && (compare.getRightExpression() instanceof Variable || compare.getRightExpression() instanceof Constant)) {
                boolean leftSideIndexed = false;
                boolean rightSideIndexed = false;
                if (OperatorParser.isTableIndexVariable(matchingMetaStateHolder, compare.getLeftExpression(), ((PrimaryKeyEventHolder)candidateEvents).getIndexAttribute())) {
                    leftSideIndexed = true;
                }
                if (OperatorParser.isTableIndexVariable(matchingMetaStateHolder, compare.getRightExpression(), ((PrimaryKeyEventHolder)candidateEvents).getIndexAttribute())) {
                    rightSideIndexed = true;
                }
                if (leftSideIndexed && !rightSideIndexed) {
                    ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(compare.getRightExpression(), matchingMetaStateHolder.getMetaStateEvent(), matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, executionPlanContext, false, 0, queryName);
                    return new PrimaryKeyOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex(), ((PrimaryKeyEventHolder)candidateEvents).getIndexPosition());
                }
                if (!leftSideIndexed && rightSideIndexed) {
                    ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(compare.getLeftExpression(), matchingMetaStateHolder.getMetaStateEvent(), matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, executionPlanContext, false, 0, queryName);
                    return new PrimaryKeyOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex(), ((PrimaryKeyEventHolder)candidateEvents).getIndexPosition());
                }
            }
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaStateHolder.getMetaStateEvent(), matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, executionPlanContext, false, 0, queryName);
            return new MapOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex());
        }
        if (candidateEvents instanceof ComplexEventChunk) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaStateHolder.getMetaStateEvent(), matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, executionPlanContext, false, 0, queryName);
            return new EventChunkOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex());
        }
        if (candidateEvents instanceof Map) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaStateHolder.getMetaStateEvent(), matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, executionPlanContext, false, 0, queryName);
            return new MapOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex());
        }
        if (candidateEvents instanceof Collection) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaStateHolder.getMetaStateEvent(), matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, executionPlanContext, false, 0, queryName);
            return new CollectionOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex());
        }
        throw new OperationNotSupportedException(candidateEvents.getClass() + " is not supported by OperatorParser!");
    }

    private static boolean isTableIndexVariable(MatchingMetaStateHolder matchingMetaStateHolder, Expression expression, String indexAttribute) {
        MetaStreamEvent tableStreamEvent;
        Variable variable;
        return expression instanceof Variable && (variable = (Variable)expression).getStreamId() != null && ((tableStreamEvent = matchingMetaStateHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaStateHolder.getCandidateEventIndex())) != null ? (tableStreamEvent.getInputReferenceId() != null && variable.getStreamId().equals(tableStreamEvent.getInputReferenceId()) || tableStreamEvent.getLastInputDefinition().getId().equals(variable.getStreamId())) && Arrays.asList(tableStreamEvent.getLastInputDefinition().getAttributeNameArray()).contains(indexAttribute) : matchingMetaStateHolder.getCandsidateDefinition().getId().equals(variable.getStreamId()));
    }
}

