/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.partition.PartitionRuntime;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.output.callback.InsertIntoStreamCallback;
import org.wso2.siddhi.core.query.output.callback.InsertIntoWindowCallback;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.stream.input.InputManager;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.trigger.EventTrigger;
import org.wso2.siddhi.core.util.lock.LockSynchronizer;
import org.wso2.siddhi.core.util.parser.helper.DefinitionParserHelper;
import org.wso2.siddhi.core.window.EventWindow;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;

public class ExecutionPlanRuntimeBuilder {
    private ConcurrentMap<String, AbstractDefinition> streamDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, AbstractDefinition> tableDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, AbstractDefinition> windowDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, TriggerDefinition> triggerDefinitionMap = new ConcurrentHashMap<String, TriggerDefinition>();
    private ConcurrentMap<String, QueryRuntime> queryProcessorMap = new ConcurrentHashMap<String, QueryRuntime>();
    private ConcurrentMap<String, StreamJunction> streamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();
    private ConcurrentMap<String, EventTable> eventTableMap = new ConcurrentHashMap<String, EventTable>();
    private ConcurrentMap<String, EventWindow> eventWindowMap = new ConcurrentHashMap<String, EventWindow>();
    private ConcurrentMap<String, EventTrigger> eventTriggerMap = new ConcurrentHashMap<String, EventTrigger>();
    private ConcurrentMap<String, PartitionRuntime> partitionMap = new ConcurrentHashMap<String, PartitionRuntime>();
    private ConcurrentMap<String, ExecutionPlanRuntime> executionPlanRuntimeMap = null;
    private ExecutionPlanContext executionPlanContext;
    private InputManager inputManager;
    private LockSynchronizer lockSynchronizer = new LockSynchronizer();

    public ExecutionPlanRuntimeBuilder(ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        this.inputManager = new InputManager(this.executionPlanContext, this.streamDefinitionMap, this.streamJunctionMap);
    }

    public void defineStream(StreamDefinition streamDefinition) {
        DefinitionParserHelper.validateDefinition((AbstractDefinition)streamDefinition, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap);
        if (!this.streamDefinitionMap.containsKey(streamDefinition.getId())) {
            this.streamDefinitionMap.putIfAbsent(streamDefinition.getId(), (AbstractDefinition)streamDefinition);
        }
        DefinitionParserHelper.addStreamJunction(streamDefinition, this.streamJunctionMap, this.executionPlanContext);
    }

    public void defineTable(TableDefinition tableDefinition) {
        DefinitionParserHelper.validateDefinition((AbstractDefinition)tableDefinition, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap);
        if (!this.tableDefinitionMap.containsKey(tableDefinition.getId())) {
            this.tableDefinitionMap.putIfAbsent(tableDefinition.getId(), (AbstractDefinition)tableDefinition);
        }
        DefinitionParserHelper.addEventTable(tableDefinition, this.eventTableMap, this.executionPlanContext);
    }

    public void defineWindow(WindowDefinition windowDefinition) {
        DefinitionParserHelper.validateDefinition((AbstractDefinition)windowDefinition, this.streamDefinitionMap, this.tableDefinitionMap, this.windowDefinitionMap);
        DefinitionParserHelper.addStreamJunction((StreamDefinition)windowDefinition, this.streamJunctionMap, this.executionPlanContext);
        if (!this.windowDefinitionMap.containsKey(windowDefinition.getId())) {
            this.windowDefinitionMap.putIfAbsent(windowDefinition.getId(), (AbstractDefinition)windowDefinition);
        }
        DefinitionParserHelper.addWindow(windowDefinition, this.eventWindowMap, this.executionPlanContext);
    }

    public void defineTrigger(TriggerDefinition triggerDefinition) {
        DefinitionParserHelper.validateDefinition(triggerDefinition);
        this.triggerDefinitionMap.putIfAbsent(triggerDefinition.getId(), triggerDefinition);
        DefinitionParserHelper.addEventTrigger(triggerDefinition, this.eventTriggerMap, this.streamJunctionMap, this.executionPlanContext);
    }

    public void addPartition(PartitionRuntime partitionRuntime) {
        this.partitionMap.put(partitionRuntime.getPartitionId(), partitionRuntime);
    }

    public String addQuery(QueryRuntime queryRuntime) {
        StreamDefinition streamDefinition;
        this.queryProcessorMap.put(queryRuntime.getQueryId(), queryRuntime);
        StreamRuntime streamRuntime = queryRuntime.getStreamRuntime();
        for (SingleStreamRuntime singleStreamRuntime : streamRuntime.getSingleStreamRuntimes()) {
            ProcessStreamReceiver processStreamReceiver = singleStreamRuntime.getProcessStreamReceiver();
            if (processStreamReceiver.toTable()) continue;
            ((StreamJunction)this.streamJunctionMap.get(processStreamReceiver.getStreamId())).subscribe(processStreamReceiver);
        }
        OutputCallback outputCallback = queryRuntime.getOutputCallback();
        if (outputCallback != null && outputCallback instanceof InsertIntoStreamCallback) {
            InsertIntoStreamCallback insertIntoStreamCallback = (InsertIntoStreamCallback)outputCallback;
            streamDefinition = insertIntoStreamCallback.getOutputStreamDefinition();
            this.streamDefinitionMap.putIfAbsent(streamDefinition.getId(), (AbstractDefinition)streamDefinition);
            DefinitionParserHelper.validateOutputStream(streamDefinition, (AbstractDefinition)this.streamDefinitionMap.get(streamDefinition.getId()));
            StreamJunction outputStreamJunction = (StreamJunction)this.streamJunctionMap.get(streamDefinition.getId());
            if (outputStreamJunction == null) {
                outputStreamJunction = new StreamJunction(streamDefinition, this.executionPlanContext.getExecutorService(), this.executionPlanContext.getBufferSize(), this.executionPlanContext);
                this.streamJunctionMap.putIfAbsent(streamDefinition.getId(), outputStreamJunction);
            }
            insertIntoStreamCallback.init((StreamJunction)this.streamJunctionMap.get(insertIntoStreamCallback.getOutputStreamDefinition().getId()));
        } else if (outputCallback != null && outputCallback instanceof InsertIntoWindowCallback) {
            InsertIntoWindowCallback insertIntoWindowCallback = (InsertIntoWindowCallback)outputCallback;
            streamDefinition = insertIntoWindowCallback.getOutputStreamDefinition();
            this.windowDefinitionMap.putIfAbsent(streamDefinition.getId(), (AbstractDefinition)streamDefinition);
            DefinitionParserHelper.validateOutputStream(streamDefinition, (AbstractDefinition)this.windowDefinitionMap.get(streamDefinition.getId()));
            StreamJunction outputStreamJunction = (StreamJunction)this.streamJunctionMap.get(streamDefinition.getId());
            if (outputStreamJunction == null) {
                outputStreamJunction = new StreamJunction(streamDefinition, this.executionPlanContext.getExecutorService(), this.executionPlanContext.getBufferSize(), this.executionPlanContext);
                this.streamJunctionMap.putIfAbsent(streamDefinition.getId(), outputStreamJunction);
            }
            insertIntoWindowCallback.getEventWindow().setPublisher(((StreamJunction)this.streamJunctionMap.get(insertIntoWindowCallback.getOutputStreamDefinition().getId())).constructPublisher());
        }
        return queryRuntime.getQueryId();
    }

    public void defineFunction(FunctionDefinition functionDefinition) {
        DefinitionParserHelper.addFunction(this.executionPlanContext, functionDefinition);
    }

    public void setExecutionPlanRuntimeMap(ConcurrentMap<String, ExecutionPlanRuntime> executionPlanRuntimeMap) {
        this.executionPlanRuntimeMap = executionPlanRuntimeMap;
    }

    public ConcurrentMap<String, StreamJunction> getStreamJunctions() {
        return this.streamJunctionMap;
    }

    public ConcurrentMap<String, EventTable> getEventTableMap() {
        return this.eventTableMap;
    }

    public ConcurrentMap<String, EventWindow> getEventWindowMap() {
        return this.eventWindowMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getTableDefinitionMap() {
        return this.tableDefinitionMap;
    }

    public ConcurrentMap<String, AbstractDefinition> getWindowDefinitionMap() {
        return this.windowDefinitionMap;
    }

    public LockSynchronizer getLockSynchronizer() {
        return this.lockSynchronizer;
    }

    public ExecutionPlanRuntime build() {
        return new ExecutionPlanRuntime(this.streamDefinitionMap, this.tableDefinitionMap, this.inputManager, this.queryProcessorMap, this.streamJunctionMap, this.eventTableMap, this.partitionMap, this.executionPlanContext, this.executionPlanRuntimeMap);
    }
}

