/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.processor.executor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.query.selector.attribute.processor.executor.AbstractAggregationAttributeExecutor;

public class GroupByAggregationAttributeExecutor
extends AbstractAggregationAttributeExecutor {
    public static final int DEFAULT_AGGREGATOR_CLEAN_INTERVAL = 60;
    protected Map<String, AttributeAggregator> aggregatorMap = new HashMap<String, AttributeAggregator>();
    protected ExpiredAggregatorTracker expiredAggregatorTracker;
    private static Map<String, List<ExpiredAggregatorTracker>> allExpiredTrackers = new HashMap<String, List<ExpiredAggregatorTracker>>();
    private static ScheduledExecutorService aggregatorCleanTimer = null;

    public GroupByAggregationAttributeExecutor(AttributeAggregator attributeAggregator, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext, String queryName) {
        super(attributeAggregator, attributeExpressionExecutors, executionPlanContext, queryName);
        if (executionPlanContext.getCleanAggregators()) {
            this.expiredAggregatorTracker = new ExpiredAggregatorTracker(executionPlanContext.getCleanAggregatorInterval());
            if (executionPlanContext.getCleanAggregatorInterval() == 60) {
                List<ExpiredAggregatorTracker> expiredTrackers = allExpiredTrackers.get(executionPlanContext.getName());
                if (expiredTrackers == null) {
                    expiredTrackers = new ArrayList<ExpiredAggregatorTracker>();
                    allExpiredTrackers.put(executionPlanContext.getName(), expiredTrackers);
                }
                expiredTrackers.add(this.expiredAggregatorTracker);
                if (aggregatorCleanTimer == null) {
                    this.createDefaultAggregatorCleanTimer();
                }
            } else {
                allExpiredTrackers.remove(executionPlanContext.getName());
            }
        }
    }

    private void createDefaultAggregatorCleanTimer() {
        aggregatorCleanTimer = Executors.newSingleThreadScheduledExecutor();
        aggregatorCleanTimer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (List trackers : allExpiredTrackers.values()) {
                    for (ExpiredAggregatorTracker tracker : trackers) {
                        tracker.clear();
                    }
                }
            }
        }, 60L, 60L, TimeUnit.MINUTES);
    }

    @Override
    public synchronized Object execute(ComplexEvent event) {
        if (event.getType() == ComplexEvent.Type.RESET) {
            Object aOutput = null;
            for (AttributeAggregator attributeAggregator : this.aggregatorMap.values()) {
                aOutput = attributeAggregator.process(event);
            }
            if (this.expiredAggregatorTracker != null) {
                this.expiredAggregatorTracker.addAll(this.aggregatorMap);
                this.aggregatorMap.clear();
            }
            return aOutput;
        }
        String key = QuerySelector.getThreadLocalGroupByKey();
        AttributeAggregator currentAttributeAggregator = this.aggregatorMap.get(key);
        if (currentAttributeAggregator == null) {
            if (this.expiredAggregatorTracker != null) {
                currentAttributeAggregator = this.expiredAggregatorTracker.remove(key);
            }
            if (currentAttributeAggregator == null) {
                currentAttributeAggregator = this.attributeAggregator.cloneAggregator(key);
                currentAttributeAggregator.initAggregator(this.attributeExpressionExecutors, this.executionPlanContext);
            }
            currentAttributeAggregator.start();
            this.aggregatorMap.put(key, currentAttributeAggregator);
        }
        return currentAttributeAggregator.process(event);
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new GroupByAggregationAttributeExecutor(this.attributeAggregator.cloneAggregator(key), this.attributeExpressionExecutors, this.executionPlanContext, this.queryName);
    }

    @Override
    public Object[] currentState() {
        HashMap<String, Object[]> data = new HashMap<String, Object[]>();
        for (Map.Entry<String, AttributeAggregator> entry : this.aggregatorMap.entrySet()) {
            data.put(entry.getKey(), entry.getValue().currentState());
        }
        return new Object[]{new AbstractMap.SimpleEntry("Data", data)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        HashMap data = (HashMap)stateEntry.getValue();
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            AttributeAggregator aAttributeAggregator = this.attributeAggregator.cloneAggregator(key);
            aAttributeAggregator.initAggregator(this.attributeExpressionExecutors, this.executionPlanContext);
            aAttributeAggregator.start();
            aAttributeAggregator.restoreState((Object[])entry.getValue());
            this.aggregatorMap.put(key, aAttributeAggregator);
        }
    }

    class ExpiredAggregatorTracker {
        private Map<String, AttributeAggregator> expiredAggregators = null;
        private ScheduledExecutorService service = null;
        private int cleanInterval;

        public ExpiredAggregatorTracker(int cleanInterval) {
            this.cleanInterval = cleanInterval;
        }

        private void init() {
            this.expiredAggregators = new HashMap<String, AttributeAggregator>();
            if (this.cleanInterval != 60) {
                this.service = Executors.newSingleThreadScheduledExecutor();
                this.service.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        ExpiredAggregatorTracker.this.clear();
                    }
                }, this.cleanInterval, this.cleanInterval, TimeUnit.MINUTES);
            }
        }

        public synchronized void add(String key, AttributeAggregator aggregator) {
            if (this.expiredAggregators == null) {
                this.init();
            }
            this.expiredAggregators.put(key, aggregator);
        }

        public synchronized void addAll(Map<String, AttributeAggregator> aggregatorMap) {
            if (this.expiredAggregators == null) {
                this.init();
            }
            this.expiredAggregators.putAll(aggregatorMap);
        }

        public synchronized AttributeAggregator remove(String key) {
            return this.expiredAggregators == null ? null : this.expiredAggregators.remove(key);
        }

        public synchronized void clear() {
            if (this.expiredAggregators != null) {
                this.expiredAggregators.clear();
                this.expiredAggregators = null;
                this.service.shutdown();
                this.service = null;
            }
        }
    }
}

