/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class MaxForeverAttributeAggregator
extends AttributeAggregator {
    private MaxForeverAttributeAggregator maxForeverAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("MaxForever aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("MaxForever not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.maxForeverAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.maxForeverAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("MaxForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.maxForeverAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("MaxForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        return this.maxForeverAttributeAggregator.reset();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return this.maxForeverAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Object[] state) {
        this.maxForeverAttributeAggregator.restoreState(state);
    }

    class MaxForeverAttributeAggregatorLong
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private volatile Long maxValue = null;

        MaxForeverAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Long value = (Long)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Long>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxValue = (Long)stateEntry.getValue();
        }
    }

    class MaxForeverAttributeAggregatorInt
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private volatile Integer maxValue = null;

        MaxForeverAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Integer value = (Integer)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Integer>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxValue = (Integer)stateEntry.getValue();
        }
    }

    class MaxForeverAttributeAggregatorFloat
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private volatile Float maxValue = null;

        MaxForeverAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Float value = (Float)data;
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Float>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxValue = (Float)stateEntry.getValue();
        }
    }

    class MaxForeverAttributeAggregatorDouble
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private volatile Double maxValue = null;

        MaxForeverAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Double value = (Double)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxValue = (Double)stateEntry.getValue();
        }
    }
}

