/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector;

import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;

public class GroupByKeyGenerator {
    private VariableExpressionExecutor[] groupByExecutors = null;

    public GroupByKeyGenerator(List<Variable> groupByList, MetaComplexEvent metaComplexEvent, Map<String, EventTable> eventTableMap, List<VariableExpressionExecutor> executors, ExecutionPlanContext siddhiContext, String queryName) {
        if (!groupByList.isEmpty()) {
            this.groupByExecutors = new VariableExpressionExecutor[groupByList.size()];
            int expressionsSize = groupByList.size();
            for (int i = 0; i < expressionsSize; ++i) {
                this.groupByExecutors[i] = (VariableExpressionExecutor)ExpressionParser.parseExpression((Expression)groupByList.get(i), metaComplexEvent, -1, eventTableMap, executors, siddhiContext, false, 0, queryName);
            }
        }
    }

    protected String constructEventKey(ComplexEvent event) {
        if (this.groupByExecutors != null) {
            StringBuilder sb = new StringBuilder();
            for (VariableExpressionExecutor executor : this.groupByExecutors) {
                sb.append(executor.execute(event)).append("::");
            }
            return sb.toString();
        }
        return null;
    }
}

