/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

public class LengthWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private int length;
    private int count = 0;
    private ComplexEventChunk<StreamEvent> expiredEventChunk;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.expiredEventChunk = new ComplexEventChunk(false);
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Length window should only have one parameter (<int> windowLength), but found " + attributeExpressionExecutors.length + " input attributes");
        }
        this.length = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        LengthWindowProcessor lengthWindowProcessor = this;
        synchronized (lengthWindowProcessor) {
            long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                if (this.count < this.length) {
                    ++this.count;
                    this.expiredEventChunk.add(clonedEvent);
                    continue;
                }
                StreamEvent firstEvent = this.expiredEventChunk.poll();
                if (firstEvent != null) {
                    firstEvent.setTimestamp(currentTime);
                    streamEventChunk.insertBeforeCurrent(firstEvent);
                    this.expiredEventChunk.add(clonedEvent);
                    continue;
                }
                StreamEvent resetEvent = streamEventCloner.copyStreamEvent(streamEvent);
                resetEvent.setType(ComplexEvent.Type.RESET);
                streamEventChunk.insertAfterCurrent(resetEvent);
                streamEventChunk.insertAfterCurrent(clonedEvent);
                streamEventChunk.next();
                streamEventChunk.next();
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.expiredEventChunk, this.streamEventCloner);
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return OperatorParser.constructOperator(this.expiredEventChunk, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.queryName);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, StreamEvent>("ExpiredEventChunk", this.expiredEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, Integer>("Count", this.count)};
    }

    @Override
    public void restoreState(Object[] state) {
        this.expiredEventChunk.clear();
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.expiredEventChunk.add((StreamEvent)stateEntry.getValue());
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.count = (Integer)stateEntry2.getValue();
    }
}

