/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.function;

import java.util.Arrays;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class Pol2CartStreamFunctionProcessor
extends StreamFunctionProcessor {
    private int inputExecutorLength;

    @Override
    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (this.inputExecutorLength < 2 || this.inputExecutorLength > 3) {
            throw new ExecutionPlanValidationException("Input parameters for poleCart can either be 'theta,rho' or 'theta,rho,z', but " + attributeExpressionExecutors.length + " attributes found");
        }
        for (int i = 0; i < this.inputExecutorLength; ++i) {
            ExpressionExecutor expressionExecutor = attributeExpressionExecutors[i];
            if (expressionExecutor.getReturnType() == Attribute.Type.DOUBLE) continue;
            throw new ExecutionPlanValidationException("Input attribute " + i + " is expected to return Double, but its returning " + expressionExecutor.getReturnType());
        }
        if (attributeExpressionExecutors.length == 2) {
            for (Attribute attribute : inputDefinition.getAttributeList()) {
                if (!attribute.getName().equals("x") && !attribute.getName().equals("y")) continue;
                throw new ExecutionPlanValidationException("Input stream " + inputDefinition.getId() + " should not contain attributes with name 'x' or 'y', but found " + attribute);
            }
            return Arrays.asList(new Attribute("x", Attribute.Type.DOUBLE), new Attribute("y", Attribute.Type.DOUBLE));
        }
        for (Attribute attribute : inputDefinition.getAttributeList()) {
            if (!attribute.getName().equals("x") && !attribute.getName().equals("y") && !attribute.getName().equals("z")) continue;
            throw new ExecutionPlanValidationException("Input stream " + inputDefinition.getId() + " should not contain attributes with name 'x' or 'y' or 'z', but found " + attribute);
        }
        return Arrays.asList(new Attribute("x", Attribute.Type.DOUBLE), new Attribute("y", Attribute.Type.DOUBLE), new Attribute("z", Attribute.Type.DOUBLE));
    }

    @Override
    protected Object[] process(Object[] data) {
        double theta = (Double)data[0];
        double rho = (Double)data[1];
        Object[] output = new Object[this.inputExecutorLength];
        output[0] = rho * Math.cos(Math.toRadians(theta));
        output[1] = rho * Math.sin(Math.toRadians(theta));
        if (this.inputExecutorLength == 3) {
            output[2] = data[2];
        }
        return output;
    }

    @Override
    protected Object[] process(Object data) {
        throw new IllegalStateException("pol2Cart cannot execute for single data " + data);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return null;
    }

    @Override
    public void restoreState(Object[] state) {
    }
}

