/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class LogicalPreStateProcessor
extends StreamPreStateProcessor {
    private LogicalStateElement.Type logicalType;
    private LogicalPreStateProcessor partnerStatePreProcessor;

    public LogicalPreStateProcessor(LogicalStateElement.Type type, StateInputStream.Type stateType, List<Map.Entry<Long, Set<Integer>>> withinStates) {
        super(stateType, withinStates);
        this.logicalType = type;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        LogicalPreStateProcessor logicalPreStateProcessor = new LogicalPreStateProcessor(this.logicalType, this.stateType, this.withinStates);
        this.cloneProperties(logicalPreStateProcessor, key);
        logicalPreStateProcessor.init(this.executionPlanContext, this.queryName);
        return logicalPreStateProcessor;
    }

    @Override
    public void addState(StateEvent stateEvent) {
        if (this.stateType == StateInputStream.Type.SEQUENCE) {
            if (this.newAndEveryStateEventList.isEmpty()) {
                this.newAndEveryStateEventList.add(stateEvent);
            }
            if (this.partnerStatePreProcessor != null && this.partnerStatePreProcessor.newAndEveryStateEventList.isEmpty()) {
                this.partnerStatePreProcessor.newAndEveryStateEventList.add(stateEvent);
            }
        } else {
            this.newAndEveryStateEventList.add(stateEvent);
            if (this.partnerStatePreProcessor != null) {
                this.partnerStatePreProcessor.newAndEveryStateEventList.add(stateEvent);
            }
        }
    }

    @Override
    public void addEveryState(StateEvent stateEvent) {
        this.newAndEveryStateEventList.add(this.stateEventCloner.copyStateEvent(stateEvent));
    }

    @Override
    public void setStartState(boolean isStartState) {
        this.isStartState = isStartState;
        if (this.partnerStatePreProcessor.isStartState != this.isStartState) {
            this.partnerStatePreProcessor.isStartState = isStartState;
        }
    }

    @Override
    public void resetState() {
        this.pendingStateEventList.clear();
        this.partnerStatePreProcessor.pendingStateEventList.clear();
        if (this.isStartState && this.newAndEveryStateEventList.isEmpty()) {
            this.init();
        }
    }

    @Override
    public void updateState() {
        this.pendingStateEventList.addAll(this.newAndEveryStateEventList);
        this.newAndEveryStateEventList.clear();
        this.partnerStatePreProcessor.pendingStateEventList.addAll(this.partnerStatePreProcessor.newAndEveryStateEventList);
        this.partnerStatePreProcessor.newAndEveryStateEventList.clear();
    }

    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        Iterator iterator = this.pendingStateEventList.iterator();
        while (iterator.hasNext()) {
            StateEvent stateEvent = (StateEvent)iterator.next();
            if (this.logicalType == LogicalStateElement.Type.OR && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) {
                iterator.remove();
                continue;
            }
            stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
            this.process(stateEvent);
            if (this.thisLastProcessor.isEventReturned()) {
                this.thisLastProcessor.clearProcessedEvent();
                returnEventChunk.add(stateEvent);
            }
            if (this.stateChanged) {
                iterator.remove();
                continue;
            }
            switch (this.stateType) {
                case PATTERN: {
                    stateEvent.setEvent(this.stateId, null);
                    break;
                }
                case SEQUENCE: {
                    stateEvent.setEvent(this.stateId, null);
                    iterator.remove();
                }
            }
        }
        return returnEventChunk;
    }

    public void setPartnerStatePreProcessor(LogicalPreStateProcessor partnerStatePreProcessor) {
        this.partnerStatePreProcessor = partnerStatePreProcessor;
    }
}

