/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class IfThenElseFunctionExecutor
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(IfThenElseFunctionExecutor.class);
    Attribute.Type returnType;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 3) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to ifThenElse() function, required only 3, but found " + attributeExpressionExecutors.length);
        }
        if (!attributeExpressionExecutors[0].getReturnType().equals((Object)Attribute.Type.BOOL)) {
            throw new ExecutionPlanValidationException("Input type of if in ifThenElse function should be of type BOOL, but found " + attributeExpressionExecutors[0].getReturnType());
        }
        if (!attributeExpressionExecutors[1].getReturnType().equals((Object)attributeExpressionExecutors[2].getReturnType())) {
            throw new ExecutionPlanValidationException("Input type of then in ifThenElse function and else in ifThenElse function should be of equivalent type. but found then type: " + attributeExpressionExecutors[1].getReturnType() + " and else type: " + attributeExpressionExecutors[2].getReturnType());
        }
        this.returnType = attributeExpressionExecutors[1].getReturnType();
    }

    @Override
    protected Object execute(Object[] data) {
        if (Boolean.TRUE.equals(data[0])) {
            return data[1];
        }
        return data[2];
    }

    @Override
    protected Object execute(Object data) {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object[] currentState() {
        return new Object[0];
    }

    @Override
    public void restoreState(Object[] state) {
    }

    @Override
    public Object execute(ComplexEvent event) {
        try {
            Boolean condition = Boolean.TRUE.equals(this.attributeExpressionExecutors[0].execute(event));
            return this.execute(new Object[]{condition, condition != false ? this.attributeExpressionExecutors[1].execute(event) : null, condition == false ? this.attributeExpressionExecutors[2].execute(event) : null});
        }
        catch (Exception e) {
            log.error((Object)("Exception on execution plan '" + this.executionPlanContext.getName() + "' on class '" + this.getClass().getName() + "', " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

