/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class CastFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to common:cast() function, required 2 parameters, but found " + attributeExpressionExecutors.length);
        }
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("The second argument has to be a string constant specifying one of the supported data types (int, long, float, double, string, bool)");
        }
        String type = attributeExpressionExecutors[1].execute(null).toString();
        if (type.toLowerCase().equals("int")) {
            this.returnType = Attribute.Type.INT;
        } else if (type.toLowerCase().equals("long")) {
            this.returnType = Attribute.Type.LONG;
        } else if (type.toLowerCase().equals("float")) {
            this.returnType = Attribute.Type.FLOAT;
        } else if (type.toLowerCase().equals("double")) {
            this.returnType = Attribute.Type.DOUBLE;
        } else if (type.toLowerCase().equals("bool")) {
            this.returnType = Attribute.Type.BOOL;
        } else if (type.toLowerCase().equals("string")) {
            this.returnType = Attribute.Type.STRING;
        } else {
            throw new ExecutionPlanValidationException("Type must be one of int,long,float,double,bool,string");
        }
    }

    @Override
    protected Object execute(Object[] data) {
        if (this.returnType == Attribute.Type.LONG && data[0] instanceof Integer) {
            return ((Integer)data[0]).longValue();
        }
        return data[0];
    }

    @Override
    protected Object execute(Object data) {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object[] currentState() {
        return null;
    }

    @Override
    public void restoreState(Object[] state) {
    }
}

