/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class ClassIndex {
    public static final String SUBCLASS_INDEX_PREFIX = "META-INF/services/";
    public static final String ANNOTATED_INDEX_PREFIX = "META-INF/annotations/";
    public static final String PACKAGE_INDEX_NAME = "jaxb.index";
    public static final String JAVADOC_PREFIX = "META-INF/javadocs/";

    private ClassIndex() {
    }

    public static <T> Iterable<Class<? extends T>> getSubclasses(Class<T> superClass) {
        return ClassIndex.getSubclasses(superClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Iterable<Class<? extends T>> getSubclasses(Class<T> superClass, ClassLoader classLoader) {
        Iterable<String> entries = ClassIndex.getSubclassesNames(superClass, classLoader);
        HashSet classes = new HashSet();
        ClassIndex.findClasses(classLoader, classes, entries);
        ArrayList<Class<T>> subclasses = new ArrayList<Class<T>>();
        for (Class clazz : classes) {
            if (!superClass.isAssignableFrom(clazz)) continue;
            subclasses.add(clazz);
        }
        return subclasses;
    }

    public static <T> Iterable<String> getSubclassesNames(Class<T> superClass) {
        return ClassIndex.getSubclassesNames(superClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Iterable<String> getSubclassesNames(Class<T> superClass, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, SUBCLASS_INDEX_PREFIX + superClass.getCanonicalName());
    }

    public static Iterable<Class<?>> getPackageClasses(String packageName) {
        return ClassIndex.getPackageClasses(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<Class<?>> getPackageClasses(String packageName, ClassLoader classLoader) {
        Iterable<String> entries = ClassIndex.readIndexFile(classLoader, packageName.replace(".", "/") + "/" + PACKAGE_INDEX_NAME);
        HashSet classes = new HashSet();
        ClassIndex.findClassesInPackage(classLoader, packageName, classes, entries);
        ClassIndex.findClasses(classLoader, classes, entries);
        return classes;
    }

    public static Iterable<String> getPackageClassesNames(String packageName) {
        return ClassIndex.getPackageClassesNames(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<String> getPackageClassesNames(String packageName, ClassLoader classLoader) {
        Iterable<String> entries = ClassIndex.readIndexFile(classLoader, packageName.replace(".", "/") + "/" + PACKAGE_INDEX_NAME);
        ArrayList<String> result = new ArrayList<String>();
        for (String simpleName : entries) {
            result.add(packageName + "." + simpleName);
        }
        return result;
    }

    public static Iterable<Class<?>> getAnnotated(Class<? extends Annotation> annotation) {
        return ClassIndex.getAnnotated(annotation, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<Class<?>> getAnnotated(Class<? extends Annotation> annotation, ClassLoader classLoader) {
        Iterable<String> entries = ClassIndex.getAnnotatedNames(annotation, classLoader);
        HashSet classes = new HashSet();
        ClassIndex.findClasses(classLoader, classes, entries);
        return classes;
    }

    public static Iterable<String> getAnnotatedNames(Class<? extends Annotation> annotation) {
        return ClassIndex.getAnnotatedNames(annotation, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<String> getAnnotatedNames(Class<? extends Annotation> annotation, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, ANNOTATED_INDEX_PREFIX + annotation.getCanonicalName());
    }

    public static String getClassSummary(Class<?> klass) {
        return ClassIndex.getClassSummary(klass, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassSummary(Class<?> klass, ClassLoader classLoader) {
        URL resource = classLoader.getResource(JAVADOC_PREFIX + klass.getCanonicalName());
        if (resource == null) {
            return null;
        }
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), "UTF-8"));){
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    int dotIndex = line.indexOf(46);
                    if (dotIndex != -1) {
                        builder.append(line.subSequence(0, dotIndex));
                        String string = builder.toString().trim();
                        return string;
                    }
                    builder.append(line);
                    line = reader.readLine();
                }
                String string = builder.toString().trim();
                return string;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ClassIndex: Cannot read Javadoc index", e);
        }
    }

    private static Iterable<String> readIndexFile(ClassLoader classLoader, String resourceFile) {
        HashSet<String> entries = new HashSet<String>();
        try {
            Enumeration<URL> resources = classLoader.getResources(resourceFile);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), "UTF-8"));
                    Throwable throwable = null;
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            entries.add(line);
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ClassIndex: Cannot read class index", e);
        }
        return entries;
    }

    private static void findClasses(ClassLoader classLoader, Set<Class<?>> classes, Iterable<String> entries) {
        for (String entry : entries) {
            Class<?> klass;
            try {
                klass = classLoader.loadClass(entry);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            classes.add(klass);
        }
    }

    private static void findClassesInPackage(ClassLoader classLoader, String packageName, Set<Class<?>> classes, Iterable<String> entries) {
        for (String entry : entries) {
            Class<?> klass;
            if (entry.contains(".")) continue;
            try {
                klass = classLoader.loadClass(packageName + "." + entry);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            classes.add(klass);
        }
    }
}

