/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.annotation.processor;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.SystemParameter;
import org.wso2.siddhi.annotation.util.AnnotationValidationException;

public class AbstractAnnotationProcessor {
    protected static final Pattern CORE_PACKAGE_PATTERN = Pattern.compile("^org.wso2.siddhi.core.");
    protected static final Pattern PARAMETER_NAME_PATTERN = Pattern.compile("^[a-z][a-z0-9]*(\\.[a-z][a-z0-9]*)*$");
    protected static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("^(([a-z][a-z0-9]+)([A-Z]{0,1}[a-z0-9]*)*)$");
    protected String extensionClassFullName;

    public AbstractAnnotationProcessor(String extensionClassFullName) {
        this.extensionClassFullName = extensionClassFullName;
    }

    public void basicParameterValidation(String name, String description, String namespace) throws AnnotationValidationException {
        if (name.isEmpty()) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> name  annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
        if (description.isEmpty()) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> description annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
        if (namespace.isEmpty() && !CORE_PACKAGE_PATTERN.matcher(this.extensionClassFullName).find()) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> namespace annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
    }

    public void parameterValidation(Parameter[] parameters) throws AnnotationValidationException {
        for (Parameter parameter : parameters) {
            String parameterName = parameter.name();
            if (parameterName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name annotated in class {0} is null or empty.", this.extensionClassFullName));
            }
            if (!PARAMETER_NAME_PATTERN.matcher(parameterName).find()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name {0} annotated in class {1} is not in proper format ''abc.def.ghi''.", parameterName, this.extensionClassFullName));
            }
            if (parameter.description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> description annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (parameter.type().length == 0) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> type annotated in class {1} is null or empty.", parameterName, this.extensionClassFullName));
            }
            if (!parameter.optional() || !parameter.defaultValue().isEmpty()) continue;
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Parameter -> name:{0} -> defaultValue annotated in class {1} cannot be null or empty for the optional parameter.", parameterName, this.extensionClassFullName));
        }
    }

    public void returnAttributesValidation(ReturnAttribute[] returnAttributes) throws AnnotationValidationException {
        for (ReturnAttribute returnAttribute : returnAttributes) {
            String returnAttributeName = returnAttribute.name();
            if (returnAttributeName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name annotated in class {0} is null or empty.", this.extensionClassFullName));
            }
            if (!CAMEL_CASE_PATTERN.matcher(returnAttributeName).find()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name {0} annotated in class {1} is not in camelCase format.", returnAttributeName, this.extensionClassFullName));
            }
            if (returnAttribute.description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name:{0} -> description annotated in class {1} is null or empty.", returnAttributeName, this.extensionClassFullName));
            }
            if (returnAttribute.type().length != 0) continue;
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @ReturnAttribute -> name:{0} -> type annotated in class {1} is null or empty.", returnAttributeName, this.extensionClassFullName));
        }
    }

    public void systemParametersValidation(SystemParameter[] systemParameters) throws AnnotationValidationException {
        for (SystemParameter systemParameter : systemParameters) {
            String systemParameterName = systemParameter.name();
            if (systemParameterName.isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @SystemParameter -> name annotated in class {0} is null or empty.", this.extensionClassFullName));
            }
            if (systemParameter.description().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @SystemParameter -> name:{0} -> description annotated in class {1} is null or empty.", systemParameterName, this.extensionClassFullName));
            }
            if (systemParameter.defaultValue().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @SystemParameter -> name:{0} -> defaultValue annotated in class {1} is null or empty.", systemParameterName, this.extensionClassFullName));
            }
            if (systemParameter.possibleParameters().length != 0) continue;
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @SystemParameter -> name:{0} -> possibleParameters annotated in class {1} is null or empty.", systemParameterName, this.extensionClassFullName));
        }
    }

    public void examplesValidation(Example[] examples) throws AnnotationValidationException {
        if (examples.length == 0) {
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Example annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
        for (Example example : examples) {
            if (example.syntax().isEmpty()) {
                throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Example -> syntax annotated in class {0} is null or empty.", this.extensionClassFullName));
            }
            if (!example.description().isEmpty()) continue;
            throw new AnnotationValidationException(MessageFormat.format("The @Extension -> @Example -> description annotated in class {0} is null or empty.", this.extensionClassFullName));
        }
    }
}

