/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.http2;

import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.transport.http.netty.contractimpl.common.HttpRoute;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.http2.EventLoopPool;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2DataEventListener;

public class Http2ConnectionManager {
    private final ConcurrentHashMap<EventLoop, EventLoopPool> eventLoopPools = new ConcurrentHashMap();
    private final Deque<EventLoop> eventLoops = new ArrayDeque<EventLoop>();
    private PoolConfiguration poolConfiguration;

    public Http2ConnectionManager(PoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
    }

    public void addHttp2ClientChannel(EventLoop eventLoop, HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        if (!this.eventLoops.contains(eventLoop)) {
            this.eventLoops.add(eventLoop);
        }
        EventLoopPool eventLoopPool = this.getOrCreateEventLoopPool(eventLoop);
        String key = this.generateKey(httpRoute);
        EventLoopPool.PerRouteConnectionPool perRouteConnectionPool = this.getOrCreatePerRoutePool(eventLoopPool, key);
        perRouteConnectionPool.addChannel(http2ClientChannel);
        http2ClientChannel.getChannel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            EventLoopPool.PerRouteConnectionPool pool = eventLoopPool.fetchPerRoutePool(key);
            if (pool != null) {
                pool.removeChannel(http2ClientChannel);
                http2ClientChannel.getDataEventListeners().forEach(Http2DataEventListener::destroy);
            }
        }));
    }

    private EventLoopPool getOrCreateEventLoopPool(EventLoop eventLoop) {
        EventLoopPool pool = this.eventLoopPools.get(eventLoop);
        if (pool != null) {
            return pool;
        }
        return this.eventLoopPools.computeIfAbsent(eventLoop, e -> new EventLoopPool());
    }

    private EventLoopPool.PerRouteConnectionPool getOrCreatePerRoutePool(EventLoopPool eventLoopPool, String key) {
        EventLoopPool.PerRouteConnectionPool perRouteConnectionPool = eventLoopPool.fetchPerRoutePool(key);
        if (perRouteConnectionPool != null) {
            return perRouteConnectionPool;
        }
        return eventLoopPool.getPerRouteConnectionPools().computeIfAbsent(key, p -> new EventLoopPool.PerRouteConnectionPool(this.poolConfiguration.getHttp2MaxActiveStreamsPerConnection()));
    }

    public Http2ClientChannel borrowChannel(Http2SourceHandler http2SrcHandler, HttpRoute httpRoute) {
        EventLoopPool.PerRouteConnectionPool perRouteConnectionPool;
        String key = this.generateKey(httpRoute);
        if (http2SrcHandler != null) {
            EventLoopPool eventLoopPool = this.getOrCreateEventLoopPool(http2SrcHandler.getChannelHandlerContext().channel().eventLoop());
            perRouteConnectionPool = this.getOrCreatePerRoutePool(eventLoopPool, key);
        } else {
            if (this.eventLoops.isEmpty()) {
                return null;
            }
            EventLoopPool eventLoopPool = this.getOrCreateEventLoopPool(this.eventLoops.peek());
            perRouteConnectionPool = this.getOrCreatePerRoutePool(eventLoopPool, key);
        }
        Http2ClientChannel http2ClientChannel = null;
        if (perRouteConnectionPool != null) {
            http2ClientChannel = perRouteConnectionPool.fetchTargetChannel();
        }
        return http2ClientChannel;
    }

    void returnClientChannel(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        EventLoopPool.PerRouteConnectionPool perRouteConnectionPool = this.fetchPerRoutePool(httpRoute, http2ClientChannel.getChannel().eventLoop());
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.addChannel(http2ClientChannel);
        }
    }

    void removeClientChannel(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        EventLoopPool.PerRouteConnectionPool perRouteConnectionPool = this.fetchPerRoutePool(httpRoute, http2ClientChannel.getChannel().eventLoop());
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.removeChannel(http2ClientChannel);
        }
    }

    private EventLoopPool.PerRouteConnectionPool fetchPerRoutePool(HttpRoute httpRoute, EventLoop eventLoop) {
        String key = this.generateKey(httpRoute);
        return this.eventLoopPools.get(eventLoop).fetchPerRoutePool(key);
    }

    private String generateKey(HttpRoute httpRoute) {
        return httpRoute.getScheme() + ":" + httpRoute.getHost() + ":" + httpRoute.getPort();
    }
}

