/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.certificatevalidation;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.cert.CertificateEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.CertificateVerificationException;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.RevocationVerifier;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.crl.CRLCache;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.crl.CRLVerifier;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.ocsp.OCSPCache;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.ocsp.OCSPVerifier;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.pathvalidation.CertificatePathValidator;

public class RevocationVerificationManager {
    private int cacheSize = 50;
    private int cacheDelayMins = 15;
    private static final Logger LOG = LoggerFactory.getLogger(RevocationVerificationManager.class);

    public RevocationVerificationManager(Integer cacheAllocatedSize, Integer cacheDelayMins) {
        if (cacheAllocatedSize != null && cacheAllocatedSize > 50 && cacheAllocatedSize < 10000) {
            this.cacheSize = cacheAllocatedSize;
        }
        if (cacheDelayMins != null && cacheDelayMins > 1 && cacheDelayMins < 1440) {
            this.cacheDelayMins = cacheDelayMins;
        }
    }

    public boolean verifyRevocationStatus(javax.security.cert.X509Certificate[] peerCertificates) throws CertificateVerificationException {
        RevocationVerifier[] verifiers;
        X509Certificate[] convertedCertificates = this.convert(peerCertificates);
        long start = System.currentTimeMillis();
        OCSPCache ocspCache = OCSPCache.getCache();
        ocspCache.init(this.cacheSize, this.cacheDelayMins);
        CRLCache crlCache = CRLCache.getCache();
        crlCache.init(this.cacheSize, this.cacheDelayMins);
        for (RevocationVerifier verifier : verifiers = new RevocationVerifier[]{new OCSPVerifier(ocspCache), new CRLVerifier(crlCache)}) {
            try {
                CertificatePathValidator pathValidator = new CertificatePathValidator(convertedCertificates, verifier);
                pathValidator.validatePath();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Path verification is successful. Took {} ms.", (Object)(System.currentTimeMillis() - start));
                }
                return true;
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} failed.", (Object)verifier.getClass().getSimpleName());
                LOG.debug("Certificate verification with {} failed. ", (Object)verifier.getClass().getSimpleName(), (Object)e);
            }
        }
        throw new CertificateVerificationException("Path verification failed for both OCSP and CRL");
    }

    private X509Certificate[] convert(javax.security.cert.X509Certificate[] certs) throws CertificateVerificationException {
        X509Certificate[] certChain = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            try {
                byte[] encoded = certs[i].getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encoded);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                certChain[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                continue;
            }
            catch (CertificateException | CertificateEncodingException e) {
                Exception exceptionThrown = e;
                throw new CertificateVerificationException("Cant Convert certificates from javax to java", exceptionThrown);
            }
        }
        return certChain;
    }
}

