/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.stockquote.example;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Contact;
import io.swagger.annotations.Info;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.stockquote.example.Stock;
import org.wso2.msf4j.stockquote.example.Stocks;
import org.wso2.msf4j.stockquote.example.exception.DuplicateSymbolException;
import org.wso2.msf4j.stockquote.example.exception.SymbolNotFoundException;

@Api(value="stockquote")
@SwaggerDefinition(info=@Info(title="Stockquote Swagger Definition", version="1.0", description="Stock quote service", license=@License(name="Apache 2.0", url="http://www.apache.org/licenses/LICENSE-2.0"), contact=@Contact(name="Afkham Azeez", email="azeez@wso2.com", url="http://wso2.com")))
@Path(value="/stockquote")
public class StockQuoteService
implements Microservice {
    private Map<String, Stock> stockQuotes = new HashMap<String, Stock>();

    public StockQuoteService() {
        this.stockQuotes.put("IBM", new Stock("IBM", "International Business Machines", 149.62, 150.78, 149.18));
        this.stockQuotes.put("GOOG", new Stock("GOOG", "Alphabet Inc.", 652.3, 657.81, 643.15));
        this.stockQuotes.put("AMZN", new Stock("AMZN", "Amazon.com", 548.9, 553.2, 543.1));
    }

    @GET
    @Path(value="/{symbol}")
    @Produces(value={"application/json", "text/xml"})
    @ApiOperation(value="Return stock quote corresponding to the symbol", notes="Returns HTTP 404 if the symbol is not found")
    @ApiResponses(value={@ApiResponse(code=200, message="Valid stock item found"), @ApiResponse(code=404, message="Stock item not found")})
    public Response getQuote(@ApiParam(value="Symbol", required=true) @PathParam(value="symbol") String symbol) throws SymbolNotFoundException {
        Stock stock = this.stockQuotes.get(symbol);
        if (stock == null) {
            throw new SymbolNotFoundException("Symbol " + symbol + " not found");
        }
        return Response.ok().entity((Object)stock).cookie(new NewCookie[]{new NewCookie("symbol", symbol)}).build();
    }

    @HEAD
    @Path(value="/{symbol}")
    @Produces(value={"application/json", "text/xml"})
    @ApiOperation(value="Returns headers of corresponding GET request ", notes="Returns metainformation contained in the HTTP header identical to the corresponding GET Request")
    public Response getMetaInformationForQuote(@ApiParam(value="Symbol", required=true) @PathParam(value="symbol") String symbol) throws SymbolNotFoundException {
        Stock stock = this.stockQuotes.get(symbol);
        if (stock == null) {
            throw new SymbolNotFoundException();
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json", "text/xml"})
    @ApiOperation(value="Return stock quote corresponding to the symbol", notes="Returns HTTP 404 if the symbol is not found")
    @ApiResponses(value={@ApiResponse(code=200, message="Valid stock item found"), @ApiResponse(code=404, message="Stock item not found")})
    public Response getQuoteUsingCookieParam(@ApiParam(value="Symbol", required=true) @CookieParam(value="symbol") String symbol) throws SymbolNotFoundException {
        Stock stock = this.stockQuotes.get(symbol);
        if (stock == null) {
            throw new SymbolNotFoundException("Symbol " + symbol + " not found");
        }
        return Response.ok().entity((Object)stock).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Add a stock item", notes="Add a valid stock item")
    public void addStock(@ApiParam(value="Stock object", required=true) Stock stock) throws DuplicateSymbolException {
        String symbol = stock.getSymbol();
        if (this.stockQuotes.containsKey(symbol)) {
            throw new DuplicateSymbolException("Symbol " + symbol + " already exists");
        }
        this.stockQuotes.put(symbol, stock);
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json", "text/xml"})
    @ApiOperation(value="Get all stocks", notes="Returns all stock items", response=Stocks.class, responseContainer="List")
    public Stocks getAllStocks(@Context Request request) {
        return new Stocks(this.stockQuotes.values());
    }

    @OPTIONS
    @Path(value="/all")
    @ApiOperation(value="Get supported reuest methods", notes="Return a response with headers that show the supported HTTP Requests on the Request-URI")
    public Response getCommunicationInformationForRequestURI() {
        return Response.ok().header("Access-Control-Allow-Methods", (Object)"GET,OPTIONS").build();
    }
}

