/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.jmeter;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.jmeter.JMeterTest;
import org.wso2.carbon.automation.extensions.jmeter.JMeterTestManager;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.MqttSubscriberClient;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class DeviceTypeManagementJMeterTestCase
extends TestBase {
    private static Log log = LogFactory.getLog(DeviceTypeManagementJMeterTestCase.class);
    private String broker = "tcp://localhost:1886";
    private RestClient restClient;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        this.restClient = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
    }

    @Test(description="This test case tests the Device Type/Device Management/Device Agent APIs")
    public void DeviceTypeManagementTest() throws AutomationFrameworkException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("jmeter-scripts" + File.separator + "DeviceTypeManagementAPI.jmx");
        JMeterTest script = new JMeterTest(new File(url.getPath()));
        JMeterTestManager manager = new JMeterTestManager();
        log.info((Object)"Running Device Type/Device Management/Device Agent management api test cases using jmeter scripts");
        manager.runTest(script);
        log.info((Object)"Completed DeviceType API service test using jmeter scripts");
    }

    @Test(description="Test whether the policy publishing from the server to device works", dependsOnMethods={"DeviceTypeManagementTest"})
    public void testMqttFlow() throws Exception {
        String deviceId = "123422578912";
        String deviceType = "firealarmmqtt";
        String payload = "{\"deviceIdentifiers\":[123422578912],\"operation\":{\"code\":\"ring\",\"type\":\"CONFIG\",\"payLoad\":\"volume:30%\"}}";
        String topic = this.automationContext.getContextTenant().getDomain() + "/" + deviceType + "/" + deviceId + "/operation/#";
        String clientId = deviceId + ":firealarmmqtt";
        MqttSubscriberClient mqttDeviceSubscriberClient = new MqttSubscriberClient(this.broker, clientId, topic, this.accessToken);
        this.restClient.post("/api/device-mgt/v1.0/devices/" + deviceType + "/operations", payload);
        Thread.sleep(10000L);
        ArrayList mqttMessages = mqttDeviceSubscriberClient.getMqttMessages();
        Assert.assertEquals((String)"listener did not recieve mqtt messages ", (int)1, (int)mqttMessages.size());
        String topicPub = this.automationContext.getContextTenant().getDomain() + "/" + deviceType + "/" + deviceId + "/events";
        int qos = 2;
        String clientIdPub = deviceId + ":firealarmmqttpub";
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient sampleClient = new MqttClient(this.broker, clientIdPub, (MqttClientPersistence)persistence);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setUserName(this.accessToken);
        connOpts.setPassword("".toCharArray());
        connOpts.setKeepAliveInterval(120);
        connOpts.setCleanSession(false);
        log.info((Object)("Connecting to broker: " + this.broker));
        sampleClient.connect(connOpts);
        log.info((Object)"Connected");
        for (int i = 0; i < 100; ++i) {
            payload = "{\"temperature\":%d,\"status\":\"workingh\",\"humidity\":20}";
            MqttMessage message = new MqttMessage(String.format(payload, i).getBytes());
            message.setQos(qos);
            sampleClient.publish(topicPub, message);
            log.info((Object)"Message is published to Mqtt Client");
            Thread.sleep(1000L);
        }
        sampleClient.disconnect();
        log.info((Object)"Mqtt Client is Disconnected");
        HttpResponse response = this.restClient.get("/api/device-mgt/v1.0/events/last-known/" + deviceType + "/" + deviceId);
        Assert.assertEquals((String)"No published event found (mqtt)", (int)200, (int)response.getResponseCode());
        log.error((Object)response.getData());
        JsonElement jsonElement = new JsonParser().parse(response.getData()).getAsJsonObject().get("count");
        int count = jsonElement.getAsInt();
        Assert.assertTrue((String)("Event count does not match published event count, " + response.getData()), (count > 0 ? 1 : 0) != 0);
    }
}

