/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.device.enrollment;

import java.io.File;
import java.net.URL;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.Constants;
import org.wso2.iot.integration.common.OAuthUtil;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class WindowsEnrollment
extends TestBase {
    private static final String BSD_PLACEHOLDER = "{BinarySecurityToken}";
    private static String bsd;
    private RestClient client;

    @BeforeClass(alwaysRun=true, groups={"windows-enrollment"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken((String)this.backendHTTPURL, (String)this.backendHTTPSURL);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows Discovery get.")
    public void testServerAvailability() throws Exception {
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        HttpResponse response = this.client.get("/mdm-windows-agent/services/discovery/get");
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows Discovery post.")
    public void testDiscoveryPost() throws Exception {
        String xml = this.readXML(Constants.WindowsEnrollment.DISCOVERY_POST_FILE, "UTF-8");
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        HttpResponse response = this.client.post("/mdm-windows-agent/services/discovery/post", xml);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows BST.")
    public void testBST() throws Exception {
        JSONObject bsdObject = new JSONObject("{\"credentials\" : {\"username\" : \"admin\", \"email\" : \"admin@wso2.com\", \"password\" : \"admin\", \"ownership\" : \"BYOD\", \"token\" : \"cbe53efd46ec612c456540f8dfef5428\"}}");
        JSONObject childObject = bsdObject.getJSONObject("credentials");
        JSONObject modifiedObject = new JSONObject();
        modifiedObject.put("token", (Object)OAuthUtil.getOAuthToken((String)this.backendHTTPURL, (String)this.backendHTTPSURL));
        childObject.put("token", (Object)modifiedObject);
        HttpResponse response = this.client.post("/mdm-windows-agent/services/federated/bst/authentication", "{\"credentials\" : {\"username\" : \"admin\", \"email\" : \"admin@wso2.com\", \"password\" : \"admin\", \"ownership\" : \"BYOD\", \"token\" : \"cbe53efd46ec612c456540f8dfef5428\"}}");
        bsd = response.getData();
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows MS XCEP post.", dependsOnMethods={"testBST"})
    public void testMSXCEP() throws Exception {
        String xml = this.readXML(Constants.WindowsEnrollment.MS_XCEP_FILE, "UTF-8");
        String payload = xml.replace(BSD_PLACEHOLDER, bsd);
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        HttpResponse response = this.client.post("/mdm-windows-agent/services/certificatepolicy/xcep", payload);
        Assert.assertEquals((int)response.getResponseCode(), (int)202);
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows WSETP post.", dependsOnMethods={"testMSXCEP"})
    public void testWSETP() throws Exception {
        String xml = this.readXML(Constants.WindowsEnrollment.WS_STEP_FILE, "UTF-8");
        String payload = xml.replace(BSD_PLACEHOLDER, bsd);
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        HttpResponse response = this.client.post("/mdm-windows-agent/services/deviceenrolment/wstep", payload);
        Assert.assertEquals((int)response.getResponseCode(), (int)202);
    }

    private String readXML(String fileName, String characterEncoding) throws Exception {
        URL url = ClassLoader.getSystemResource(fileName);
        File folder = new File(url.toURI());
        return FileUtils.readFileToString((File)folder, (String)characterEncoding);
    }
}

