/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.device.configuration;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.AssertUtil;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class AndroidConfigurationManagement
extends TestBase {
    private RestClient client;

    @Factory(dataProvider="userModeProvider")
    public AndroidConfigurationManagement(TestUserMode testUserMode) {
        this.userMode = testUserMode;
    }

    @BeforeClass(alwaysRun=true, groups={"user-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
    }

    @Test(description="Test update android configuration.")
    public void testModifyConfiguration() throws Exception {
        HttpResponse response = this.client.put("/api/device-mgt/android/v1.0/configuration/", PayloadGenerator.getJsonPayload((String)"android-configuration-payloads.json", (String)"PUT").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        Assert.assertEquals((String)"Android configuration update message is not received properly", (String)"Android platform configuration has been updated successfully.", (String)response.getData().replaceAll("\"", ""));
    }

    @Test(description="Test get android configuration.", dependsOnMethods={"testModifyConfiguration"})
    public void testGetConfiguration() throws Exception {
        HttpResponse response = this.client.get("/api/device-mgt/android/v1.0/configuration/");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"android-configuration-payloads.json", (String)"PUT").toString(), (String)response.getData(), (boolean)true);
    }

    @Test(description="Test get android license.", dependsOnMethods={"testModifyConfiguration"})
    public void testGetLicense() throws Exception {
        HttpResponse response = this.client.get("/api/device-mgt/android/v1.0/configuration/license");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        Assert.assertEquals((String)"Expected android license agreement is not received", (String)"This End User License Agreement is Eula.", (String)response.getData());
    }
}

