/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.configuration;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.AssertUtil;
import org.wso2.iot.integration.common.OAuthUtil;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class ConfigurationManagement
extends TestBase {
    private RestClient client;

    @BeforeClass(alwaysRun=true, groups={"configuration-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken((String)this.backendHTTPSURL, (String)this.backendHTTPSURL);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test save configuration.")
    public void testSaveConfiguration() throws Exception {
        HttpResponse response = this.client.post("/mdm-admin/configuration", PayloadGenerator.getJsonPayload((String)"configuration-payloads.json", (String)"POST").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"configuration-response-payloads.json", (String)"POST").toString(), (String)response.getData().toString(), (boolean)true);
    }

    @Test(description="Test get configuration.", dependsOnMethods={"testSaveConfiguration"})
    public void testGetConfiguration() throws Exception {
        HttpResponse response = this.client.get("/mdm-admin/configuration");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"configuration-response-payloads.json", (String)"GET").toString(), (String)response.getData().toString(), (boolean)true);
    }
}

