/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.samples;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.MqttSubscriberClient;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class VirtualFireAlarmTestCase
extends TestBase {
    private static Log log = LogFactory.getLog(VirtualFireAlarmTestCase.class);
    public static String deviceId1;
    public static String deviceId2;
    public static String tenantDeviceId1;
    public static String tenantDeviceId2;
    public static long currentTime;
    private String broker = "tcp://localhost:1886";
    private String DEVICE_TYPE = "virtual_firealarm";
    private RestClient restClient;

    @Factory(dataProvider="userModeProvider")
    public VirtualFireAlarmTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.restClient = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
        if (this.userMode == TestUserMode.TENANT_ADMIN) {
            HttpResponse response = this.restClient.post("/api/device-mgt/v1.0/admin/publish-artifact/1.0.0/deploy/virtual_firealarm", "");
            Assert.assertEquals((int)201, (int)response.getResponseCode());
        }
    }

    @Test(description="This test case tests the virtual fire alarm enrollment")
    public void testEnrollment() throws Exception {
        Thread.sleep(30000L);
        RestClient client = new RestClient(this.backendHTTPSURL, "application/zip", this.accessTokenString);
        HttpResponse response = client.get("/virtual_firealarm/1.0.0/device/download?deviceName=advanced&sketchType=virtual_firealarm_advanced");
        Assert.assertEquals((String)"Advance fire alarm advance agent enrollment failed", (int)200, (int)response.getResponseCode());
        response = client.get("/virtual_firealarm/1.0.0/device/download?deviceName=simple&sketchType=virtual_firealarm");
        Assert.assertEquals((String)"Advance fire alarm advance agent enrollment failed", (int)200, (int)response.getResponseCode());
        response = client.get("/api/device-mgt/v1.0/devices?type=virtual_firealarm");
        JsonArray jsonArray = new JsonParser().parse(response.getData()).getAsJsonObject().getAsJsonArray("devices");
        Assert.assertEquals((String)"Virtual fire alarm enrollment failed ", (int)2, (int)jsonArray.size());
        if (this.userMode != TestUserMode.TENANT_ADMIN) {
            deviceId1 = jsonArray.get(0).getAsJsonObject().getAsJsonPrimitive("deviceIdentifier").getAsString();
            deviceId2 = jsonArray.get(1).getAsJsonObject().getAsJsonPrimitive("deviceIdentifier").getAsString();
        } else {
            tenantDeviceId1 = jsonArray.get(0).getAsJsonObject().getAsJsonPrimitive("deviceIdentifier").getAsString();
            tenantDeviceId2 = jsonArray.get(1).getAsJsonObject().getAsJsonPrimitive("deviceIdentifier").getAsString();
        }
    }

    @Test(description="Test whether the publishing to a mqtt broker works fine without exceptions", dependsOnMethods={"testEnrollment"})
    public void testEventPublishing() throws Exception {
        MqttMessage message;
        int i;
        String deviceId1 = this.userMode == TestUserMode.TENANT_ADMIN ? tenantDeviceId1 : VirtualFireAlarmTestCase.deviceId1;
        String deviceId2 = this.userMode == TestUserMode.TENANT_ADMIN ? tenantDeviceId2 : VirtualFireAlarmTestCase.deviceId2;
        String topic = this.automationContext.getContextTenant().getDomain() + "/" + this.DEVICE_TYPE + "/" + deviceId1 + "/temperature";
        int qos = 2;
        String clientId = deviceId1 + ":" + this.DEVICE_TYPE;
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient sampleClient = new MqttClient(this.broker, clientId, (MqttClientPersistence)persistence);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setUserName(this.accessToken);
        connOpts.setPassword("".toCharArray());
        connOpts.setKeepAliveInterval(120);
        connOpts.setCleanSession(true);
        log.info((Object)("Connecting to broker: " + this.broker));
        sampleClient.connect(connOpts);
        log.info((Object)"Connected");
        JsonObject fireAlarmPayload = PayloadGenerator.getJsonPayload((String)"virtual-fire-alarm-enrollment-payloads.json", (String)"PUBLISH_DATA");
        JsonObject eventPayload = fireAlarmPayload.getAsJsonObject("event");
        JsonObject metaDataPayload = eventPayload.getAsJsonObject("metaData");
        metaDataPayload.addProperty("deviceId", deviceId1);
        eventPayload.add("metaData", (JsonElement)metaDataPayload);
        fireAlarmPayload.add("event", (JsonElement)eventPayload);
        for (i = 0; i < 100; ++i) {
            message = new MqttMessage(fireAlarmPayload.toString().getBytes());
            message.setQos(qos);
            sampleClient.publish(topic, message);
            Thread.sleep(1000L);
        }
        log.info((Object)"Message is published to Mqtt Client");
        sampleClient.disconnect();
        log.info((Object)"Mqtt Client is Disconnected");
        topic = this.automationContext.getContextTenant().getDomain() + "/" + this.DEVICE_TYPE + "/" + deviceId2 + "/temperature";
        clientId = deviceId2 + ":" + this.DEVICE_TYPE;
        persistence = new MemoryPersistence();
        sampleClient = new MqttClient(this.broker, clientId, (MqttClientPersistence)persistence);
        connOpts = new MqttConnectOptions();
        connOpts.setUserName(this.accessToken);
        connOpts.setPassword("".toCharArray());
        connOpts.setKeepAliveInterval(120);
        connOpts.setCleanSession(true);
        log.info((Object)("Connecting to broker: " + this.broker));
        sampleClient.connect(connOpts);
        log.info((Object)"Connected");
        fireAlarmPayload = PayloadGenerator.getJsonPayload((String)"virtual-fire-alarm-enrollment-payloads.json", (String)"PUBLISH_DATA");
        eventPayload = fireAlarmPayload.getAsJsonObject("event");
        metaDataPayload = eventPayload.getAsJsonObject("metaData");
        metaDataPayload.addProperty("deviceId", deviceId2);
        eventPayload.add("metaData", (JsonElement)metaDataPayload);
        fireAlarmPayload.add("event", (JsonElement)eventPayload);
        for (i = 0; i < 100; ++i) {
            message = new MqttMessage(fireAlarmPayload.toString().getBytes());
            message.setQos(qos);
            sampleClient.publish(topic, message);
            Thread.sleep(1000L);
        }
        log.info((Object)"Message is published to Mqtt Client");
        sampleClient.disconnect();
        log.info((Object)"Mqtt Client is Disconnected");
        currentTime = System.currentTimeMillis();
    }

    @Test(description="Test whether the policy publishing from the server to device works", dependsOnMethods={"testEventPublishing"})
    public void testPolicyPublishing() throws Exception {
        String deviceId2 = this.userMode == TestUserMode.TENANT_ADMIN ? tenantDeviceId2 : VirtualFireAlarmTestCase.deviceId2;
        String topic = this.automationContext.getContextTenant().getDomain() + "/" + this.DEVICE_TYPE + "/" + deviceId2 + "/operation/#";
        String clientId = deviceId2 + ":" + this.DEVICE_TYPE;
        HttpResponse response = this.restClient.post("/api/device-mgt/v1.0/policies", PayloadGenerator.getJsonPayload((String)"virtual-fire-alarm-enrollment-payloads.json", (String)"POLICY_DATA").toString());
        Assert.assertEquals((String)"Policy creation for virtual fire alarm failed", (int)201, (int)response.getResponseCode());
        JsonObject jsonObject = new JsonParser().parse(response.getData()).getAsJsonObject();
        String policyId = jsonObject.getAsJsonPrimitive("id").getAsString();
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)new JsonPrimitive(policyId));
        response = this.restClient.post("/api/device-mgt/v1.0/policies/activate-policy", jsonArray.toString());
        Assert.assertEquals((String)"Policy activation for virtual fire alarm failed", (int)200, (int)response.getResponseCode());
        MqttSubscriberClient mqttSubscriberClient = new MqttSubscriberClient(this.broker, clientId, topic, this.accessToken);
        response = this.restClient.put("/api/device-mgt/v1.0/policies/apply-changes", "");
        Assert.assertEquals((String)"Applying changes to policy for virtual fire alarm failed", (int)200, (int)response.getResponseCode());
        Thread.sleep(20000L);
        ArrayList mqttMessages = mqttSubscriberClient.getMqttMessages();
        Assert.assertEquals((String)"Policy published message is not received by the mqtt listener. ", (int)2, (int)mqttMessages.size());
    }

    @Test(description="Test whether data that is published is stored in analytics event table", dependsOnMethods={"testPolicyPublishing"})
    public void testBatchDataPersistence() throws Exception {
        String deviceId1 = this.userMode == TestUserMode.TENANT_ADMIN ? tenantDeviceId1 : VirtualFireAlarmTestCase.deviceId1;
        String deviceId2 = this.userMode == TestUserMode.TENANT_ADMIN ? tenantDeviceId2 : VirtualFireAlarmTestCase.deviceId2;
        long MilliSecondDifference = System.currentTimeMillis() - currentTime;
        if (MilliSecondDifference < 300000L) {
            Thread.sleep(300000L - MilliSecondDifference);
        }
        String url = "/virtual_firealarm/1.0.0/device/stats/" + deviceId1;
        url = url + "?from=" + (currentTime - 300000L) / 1000L + "&to=" + System.currentTimeMillis() / 1000L;
        HttpResponse response = this.restClient.get(url);
    }
}

