/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.samples;

import java.io.File;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class MobileQSGTestCase
extends TestBase {
    private RestClient client;
    private String username1;
    private String username2;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        this.username1 = "alex";
        this.username2 = "chris";
        this.client = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
    }

    @Test(description="This test case tests the execution of QSG script, whether it executes without any exceptions")
    public void executeQSGScript() throws IOException, InterruptedException {
        String scriptPath = FrameworkPathUtil.getCarbonHome() + File.separator + "samples" + File.separator + "mobile-qsg";
        File scriptFile = new File(scriptPath);
        String[] cmdArray = new String[]{"sh", "mobile-qsg.sh"};
        Runtime.getRuntime().exec(cmdArray, null, scriptFile);
        Thread.sleep(10000L);
    }

    @Test(description="This test case tests whether user and roles are created as expected", dependsOnMethods={"executeQSGScript"})
    public void testUserRoleCreation() throws Exception {
        String url = "/api/device-mgt/v1.0/users/" + this.username1;
        HttpResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        url = "/api/device-mgt/v1.0/users/" + this.username2;
        response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        String rolename = "iotMobileUser";
        response = this.client.get("/api/device-mgt/v1.0/roles/" + rolename);
        Assert.assertEquals((int)200, (int)response.getResponseCode());
    }

    @Test(description="This test case tests whether app-catalogue is created from qsg script", dependsOnMethods={"executeQSGScript"})
    public void testMobileApp() throws Exception {
        RestClient appManagerRestClient = new RestClient(this.automationContext.getContextUrls().getWebAppURLHttps(), "application/json", this.accessTokenString);
        HttpResponse response = appManagerRestClient.get("/api/appm/publisher/v1.1/apps/mobileapp");
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
        Assert.assertTrue((boolean)response.getData().contains("WSO2Con-Android"), (String)"Con-App-Android addition through script is not successful");
    }

    @Test(description="This test case tests the policy creation through qsg script", dependsOnMethods={"executeQSGScript"})
    public void testPolicyCreation() throws Exception {
        HttpResponse response = this.client.get("/api/device-mgt/v1.0/policies?offset=0&limit=10");
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
        Assert.assertTrue((boolean)response.getData().contains("android-passcode-policy1"), (String)"Android pass-code policy is not added from qsg script");
        Assert.assertTrue((boolean)response.getData().contains("windows-passcode-policy1"), (String)"Windows pass-code policy is not added from qsg script");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.client != null) {
            String url = "/api/device-mgt/v1.0/users/" + this.username1;
            this.client.delete(url);
            url = "/api/device-mgt/v1.0/users/" + this.username2;
            this.client.delete(url);
        }
    }
}

