/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.policy;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.iot.integration.common.IOTHttpClient;
import org.wso2.iot.integration.common.IOTResponse;
import org.wso2.iot.integration.common.OAuthUtil;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.TestBase;

public class PolicyManagement
extends TestBase {
    private IOTHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"policy-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken((String)this.backendHTTPSURL, (String)this.backendHTTPSURL);
        this.client = new IOTHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test add policy.")
    public void testAddPolicy() throws Exception {
        IOTResponse response = this.client.post("/mdm-admin/policies/active-policy", PayloadGenerator.getJsonPayload((String)"policy-payloads.json", (String)"POST").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload((String)"policy-response-payloads.json", (String)"POST").toString(), (String)response.getBody());
    }

    @Test(description="Test view policy list.", dependsOnMethods={"testAddPolicy"})
    public void testViewPolicyList() throws Exception {
        IOTResponse response = this.client.get("/api/device-mgt/v1.0/policies");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test update policy.", dependsOnMethods={"testViewPolicyList"})
    public void testUpdatePolicy() throws Exception {
        IOTResponse response = this.client.put("/mdm-admin/policies/1", PayloadGenerator.getJsonPayload((String)"policy-payloads.json", (String)"PUT").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload((String)"policy-response-payloads.json", (String)"PUT").toString(), (String)response.getBody());
    }

    @Test(description="Test remove policy.", dependsOnMethods={"testUpdatePolicy"})
    public void testRemovePolicy() throws Exception {
        IOTResponse response = this.client.post("/mdm-admin/policies/bulk-remove", "[1]");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload((String)"policy-response-payloads.json", (String)"DELETE").toString(), (String)response.getBody());
    }
}

