/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.notification;

import com.google.gson.JsonObject;
import junit.framework.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.AssertUtil;
import org.wso2.iot.integration.common.OAuthUtil;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class NotificationManagement
extends TestBase {
    private RestClient client;

    @BeforeTest(alwaysRun=true, groups={"notification-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken((String)this.backendHTTPSURL, (String)this.backendHTTPSURL);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", accessTokenString);
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload((String)"android-enrollment-payloads.json", (String)"POST");
        enrollmentData.addProperty("deviceIdentifier", "d24f870f390352a41234");
        this.client.post("/api/device-mgt/android/v1.0/devices", enrollmentData.toString());
    }

    @Test(description="Test add notification.")
    public void testAddNotification() throws Exception {
        HttpResponse response = this.client.post("/mdm-admin/notifications", PayloadGenerator.getJsonPayload((String)"notification-payloads.json", (String)"POST").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"notification-response-payloads.json", (String)"POST").toString(), (String)response.getData().toString(), (boolean)true);
    }

    @Test(description="Test update notification.", dependsOnMethods={"testAddNotification"})
    public void testUpdateNotification() throws Exception {
        HttpResponse response = this.client.put("/mdm-admin/notifications/1234/NEW", PayloadGenerator.getJsonPayload((String)"notification-payloads.json", (String)"PUT").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare((String)PayloadGenerator.getJsonPayload((String)"notification-response-payloads.json", (String)"PUT").toString(), (String)response.getData().toString(), (boolean)true);
    }

    @Test(description="Test get notification.", dependsOnMethods={"testUpdateNotification"})
    public void testGetNotification() throws Exception {
        HttpResponse response = this.client.get("/mdm-admin/notifications");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
    }
}

