/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.mobileDevice;

import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.iot.integration.common.IOTHttpClient;
import org.wso2.iot.integration.common.IOTResponse;
import org.wso2.iot.integration.common.OAuthUtil;
import org.wso2.iot.integration.common.TestBase;

public class MobileDeviceManagementWithNoDevices
extends TestBase {
    private static Log log = LogFactory.getLog(MobileDeviceManagementWithNoDevices.class);
    private IOTHttpClient client;

    @Factory(dataProvider="userModeProvider")
    public MobileDeviceManagementWithNoDevices(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeSuite
    public void verifyApiPublishing() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        TimeUnit.SECONDS.sleep(60L);
    }

    @BeforeClass(alwaysRun=true, groups={"user-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.client = new IOTHttpClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
    }

    @Test(description="Test count devices with no added devices")
    public void testCountDevicesWithNoDevices() throws Exception {
        IOTResponse response = this.client.get("/api/device-mgt/v1.0/devices");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)"{\"devices\":[],\"count\":0}", (String)response.getBody());
    }

    private boolean checkScopes(String permissionsList) throws Exception {
        String tokenString = OAuthUtil.getScopes((String)this.backendHTTPSURL, (String)this.backendHTTPSURL);
        log.info((Object)("issued-scopes: " + tokenString));
        return tokenString.contains(permissionsList);
    }
}

