/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.mobileDevice;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class MobileDeviceManagement
extends TestBase {
    private RestClient client;

    @Factory(dataProvider="userModeProvider")
    public MobileDeviceManagement(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true, groups={"mobile-device-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload((String)"android-enrollment-payloads.json", (String)"POST");
        enrollmentData.addProperty("deviceIdentifier", "d24f870f390352a41234");
        this.client.post("/api/device-mgt/android/v1.0/devices", enrollmentData.toString());
    }

    @Test(description="Test getting devices")
    public void testViewDevices() throws Exception {
        int expectedCount = this.userMode == TestUserMode.TENANT_ADMIN ? 3 : 23;
        HttpResponse response = this.client.get("/api/device-mgt/v1.0/devices/");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        JsonObject devices = new JsonParser().parse(response.getData()).getAsJsonObject();
        Assert.assertEquals((String)"Expected device count is not received", (int)expectedCount, (int)devices.get("count").getAsInt());
    }

    @Test(description="Test getting devices")
    public void testGetUserDevices() throws Exception {
        int expectedCount = this.userMode == TestUserMode.TENANT_ADMIN ? 3 : 13;
        HttpResponse response = this.client.get("/api/device-mgt/v1.0/devices/user-devices");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        JsonObject devices = new JsonParser().parse(response.getData()).getAsJsonObject();
        Assert.assertEquals((String)"Expected device count is not received", (int)expectedCount, (int)devices.get("count").getAsInt());
    }

    @Test(description="Test Advance search")
    public void testAdvancedSearch() throws Exception {
        JsonArray pendingOperationsData = PayloadGenerator.getJsonArray((String)"android-enrollment-payloads.json", (String)"GET_PENDING_OPERATIONS");
        JsonArray newPayload = new JsonArray();
        HttpResponse response = this.client.put("/api/device-mgt/android/v1.0/devices/d24f870f390352a41234/pending-operations", pendingOperationsData.toString());
        JsonArray pendingOperations = new JsonParser().parse(response.getData()).getAsJsonArray();
        for (JsonElement pendingOperation : pendingOperations) {
            JsonObject jsonObject = pendingOperation.getAsJsonObject();
            if (!jsonObject.get("code").getAsString().equals("DEVICE_INFO")) continue;
            jsonObject.addProperty("operationResponse", PayloadGenerator.getJsonPayload((String)"mobile-device-mgt-payloads.json", (String)"UPDATE_DEVICE_INFO").toString());
            jsonObject.addProperty("status", "COMPLETED");
            newPayload.add((JsonElement)jsonObject);
            break;
        }
        this.client.put("/api/device-mgt/android/v1.0/devices/d24f870f390352a41234/pending-operations", newPayload.toString());
        response = this.client.post("/api/device-mgt/v1.0/devices/search-devices", PayloadGenerator.getJsonPayload((String)"mobile-device-mgt-payloads.json", (String)"ADVANCE_SEARCH").toString());
        JsonObject devices = new JsonParser().parse(response.getData()).getAsJsonObject();
        Assert.assertEquals((String)"Expected device count is not received", (int)1, (int)devices.get("devices").getAsJsonArray().size());
    }
}

