/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.iot.integration.device.operation;

import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.iot.integration.common.PayloadGenerator;
import org.wso2.iot.integration.common.RestClient;
import org.wso2.iot.integration.common.TestBase;

public class AndroidOperation
extends TestBase {
    private RestClient client;

    @Factory(dataProvider="userModeProvider")
    public AndroidOperation(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true, groups={"user-mgt"})
    public void initTest() throws Exception {
        super.init(this.userMode);
        this.client = new RestClient(this.backendHTTPSURL, "application/json", this.accessTokenString);
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload((String)"android-enrollment-payloads.json", (String)"POST");
        this.client.post("/api/device-mgt/android/v1.0/devices", enrollmentData.toString());
    }

    @Test(groups={"operations"}, description="Test Android device lock operation.")
    public void testLock() throws MalformedURLException, AutomationFrameworkException {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/lock-devices", "{ \"deviceIDs\": [\"d24f870f390352a41234\"],\"operation\": { \"message\": \"string\", \"hardLockEnabled\": false }}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device un-lock operation.")
    public void testUnLock() throws MalformedURLException, AutomationFrameworkException {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/unlock-devices", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device location operation.")
    public void testLocation() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/location", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device clear password operation.")
    public void testClearPassword() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/clear-password", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device camera operation.")
    public void testCamera() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/control-camera", "{\n  \"operation\": {\n    \"enabled\": false\n  },\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\" \n  ]\n}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android get info operation")
    public void testGetInfo() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/info", "[\"d24f870f390352a41234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android logcat operation")
    public void testLogcat() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/logcat", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android enterprise-wipe operation.")
    public void testEnterpriseWipe() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/enterprise-wipe", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android wipe data operation.")
    public void testWipeData() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/wipe", "{\n  \"operation\": {\n    \"pin\": \"string\"\n  },\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ]\n}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android get applications operation.")
    public void testGetApplications() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/applications", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android app install operation")
    public void testInstallApplication() throws Exception {
        JsonObject installApplicationPayload = PayloadGenerator.getJsonPayload((String)"android-operation-payloads.json", (String)"install_apps");
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/install-application", installApplicationPayload.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android app update operation")
    public void testUpdateApplication() throws FileNotFoundException, MalformedURLException, AutomationFrameworkException {
        JsonObject installApplicationPayload = PayloadGenerator.getJsonPayload((String)"android-operation-payloads.json", (String)"install_apps");
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/update-application", installApplicationPayload.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android app un-install operation")
    public void testUninstallApplication() throws MalformedURLException, AutomationFrameworkException {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/uninstall-application", "{\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ],\n  \"operation\": {\n    \"appIdentifier\": \"string\",\n    \"type\": \"enterprise\"} }");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test black list application operation")
    public void testBlackListApplication() throws FileNotFoundException, MalformedURLException, AutomationFrameworkException {
        JsonObject blackListApplicationPayload = PayloadGenerator.getJsonPayload((String)"android-operation-payloads.json", (String)"black_list_application");
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/blacklist-applications", blackListApplicationPayload.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test upgrade firmware operation")
    public void testUpgradeFirmware() throws FileNotFoundException, MalformedURLException, AutomationFrameworkException {
        JsonObject upgradeFirmWarePayload = PayloadGenerator.getJsonPayload((String)"android-operation-payloads.json", (String)"upgrade-firmware");
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/upgrade-firmware", upgradeFirmWarePayload.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test configure VPN operation")
    public void testConfigureVPN() throws FileNotFoundException, MalformedURLException, AutomationFrameworkException {
        JsonObject configureVPNPayload = PayloadGenerator.getJsonPayload((String)"android-operation-payloads.json", (String)"vpn");
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/configure-vpn", configureVPNPayload.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android reboot operation")
    public void testReboot() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/reboot", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android ring operation.")
    public void testRing() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/ring", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android mute operation.")
    public void testMute() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/mute", "[d24f870f390352a41234]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android notification operation.")
    public void testNotification() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/send-notification", "{\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ],\n  \"operation\": {\n    \"messageText\": \"string\",\n    \"messageTitle\": \"string\"\n  }\n}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android WiFi operation.")
    public void testWiFi() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/configure-wifi", "{\n  \"operation\": {\n    \"ssid\": \"string\",\n    \"password\": \"string\"\n  },\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ]\n}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android encrypt operation.")
    public void testEncrypt() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/encrypt-storage", "{\n  \"operation\": {\n    \"encrypted\": false\n  },\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ]\n}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android change lock operation.")
    public void testChangeLock() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/change-lock-code", "{\n  \"operation\": {\n    \"lockCode\": \"0000\"\n  },\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ]\n}\n");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android password policy operation.")
    public void testPasswordPolicy() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/set-password-policy", "{\n  \"operation\": {\n    \"maxFailedAttempts\": 0,\n    \"minLength\": 0,\n    \"pinHistory\": 0,\n    \"minComplexChars\": 0,\n    \"maxPINAgeInDays\": 0,\n    \"requireAlphanumeric\": false,\n    \"allowSimple\": false\n  },\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ]\n}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android web clip operation.")
    public void testWebClip() throws Exception {
        HttpResponse response = this.client.post("/api/device-mgt/android/v1.0/admin/devices/set-webclip", "{\n  \"operation\": {\n    \"identity\": \"string\",\n    \"title\": \"string\",\n    \"type\": \"string\"\n  },\n  \"deviceIDs\": [\n    \"d24f870f390352a41234\"\n  ]\n}");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }
}

